<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Enums\ModelType;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;
use Exception;
use Illuminate\Support\Str;


/**
 * JasonApi Code Generator Class
 *
 * @version     5.5.0 / 2025-04-13
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PolicyGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias;


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Policies';


    /**
     * @var     string $_modelNamespace
     */
    protected $_modelNamespace;


    /**
     * @var     string $_originalPackageName
     */
    protected $_originalPackageName;


    /**
     * @var     string $_packageNamespace
     */
    protected $_packageNamespace;


    /**
     * @var     array $_relationFields
     */
    protected $_relationFields = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiPolicy->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $name
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _addRelation(string $name): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Duplicate relation ['.$name.']');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] = $this->_relationFields[$key];
            }
            $this->_errors[$key][] = $name;

            $key .= 'Failure';
            $name .= 'Failure';
        }
        $this->_relationFields[$key] = $name;

        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    $this
     *
     * @version     1.8.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $this->_packageNamespace.'\\Models';
        $this->_namespace = $this->_packageNamespace.'\\Policies';

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            $this->_modelNamespace.'\\'.$this->_typeName,
            'App\\Models\\User',
            'Illuminate\\Auth\\Access\\Response',
        ]);
        return parent::_prepareUses();

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.3.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $fileContents = file_get_contents($this->_stubPath.'/policy.stub');

        } else {
            $fileContents = file_get_contents($this->_stubPath.'/derived.policy.stub');

            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClassAlias, $fileContents);
        }
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.1 / 2024-10-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareMethodReplacement(): string
    {
        ksort($this->_relationFields);
        /*
        **  Ersetzungs-String für die Relationen-Methoden zusammenstellen. */
        $replacement = '';

        foreach ($this->_relationFields as $relationName) {
            $fileContents = file_get_contents($this->_stubPath.'/snippets/policy/method.stub');

            $fileContents = parent::replacePlaceholder('method', $relationName, $fileContents);
            $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);

            $replacement .= $fileContents;
        }
        return $replacement;

    } // _prepareMethodReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processType();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_Type->getAdditionalRelations() as $additionalRelation) {
            $methodName = Str::studly($additionalRelation['relationName']);

            $this->_addRelation($methodName);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.7.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getAttribute('columnName');

                $RelatedType = $BackReference->getRelatedType();

                if ($BackReference->getModelType() === ModelType::Pivot) {
                    $pivotTables = $RelatedType->getPivotTables();

                    if (isset($pivotTables[$this->_tableName])) {
                        $Type = CodeGenerator::getType($pivotTables[$this->_tableName]);

                    } else {
                        /*
                        **  Dieser Fall dürfte eigentlich nie eintreten. */
                        throw new Exception('Undefined pivot table "'.$this->_tableName.'".');
                    }
                } else {
                    $Type = $BackReference->getRelatedType();
                }
                $foreignKey = $RelatedType->getForeignKey($columnName);
                $methodName = $Type->getBaseName(CaseStyle::Studly, Number::Plural);

                if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    // TODO     Str eliminieren
                    $methodName = Str::studly($foreignKey['reverseRelationName']);
                }
                if ($this->_GeneratorMode === GeneratorMode::Default) {
                    /*
                    **  Im Default-Modus werden die Policies zum jeweiligen Paket/Projekt erzeugt.
                    **  Wenn die aktuell zu erzeugende Datei zum Projekt gehört, dann sollen darin alle Relationen
                    **  enthalten sein, auch wenn sie auf ein externes Paket verweisen. In den Paketen dürfen aber
                    **  nur Relationen enthalten sein, die innerhalb des Pakets existieren. */
                    if ($this->_PackageType === PackageType::Project) {
                        $this->_addRelation($methodName);

                    } elseif ($this->_packageName === $RelatedType->getPackage()?->getName()) {
                        $this->_addRelation($methodName);
                    }
                } else {
                    /*
                    **  Im Derived-Modus werden die abgeleiteten Policies im Projekt angelegt.
                    **  Da diese von den Policy-Klassen in den Paketen abgeleitet sind, müssen sie nur die
                    **  Relationen ergänzen, die dort fehlen. */
                    //  todo    Logik überprüfen, sobald die Relation vom Projekt-User zum Package-Tenant vorhanden ist.
                    if ($this->_originalPackageName !== $RelatedType->getPackage()?->getName()) {
                        $this->_addRelation($methodName);
                    }
                }
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-13
     * @history     PolicyGenerator::_processTypeDefinition(), 1.4.0 / 2024-10-27
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processType(): self
    {
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            /*
            **  Foreign-Keys abarbeiten. */
            foreach ($this->_Fields as $Field) {
                if ($Field->isForeignKey() === true) {
                    if ($Field->isForeignKey() === false) {
                        continue;
                    }
                    $methodName = $Field->getBaseName(CaseStyle::Studly, Number::Singular);

                    $this->_addRelation($methodName);
                }
            }
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_initUses();

        return $this;

    } // _processType()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Policy-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Policy.php', $fileContents);

        if ($this->_PackageType === PackageType::Package) {
            new DerivedPolicyGenerator($this->_Type);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PolicyGenerator extends JsonApiFileGenerator {}
