<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\RouteGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\ServerGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\ExceptionHandlerGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     1.10.0 / 2025-04-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class JsonApiGenerator extends BaseGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_jsonApiNameSpace
     */
    protected $_jsonApiNameSpace;


    /**
     * @var     array $_jsonApiServers
     */
    protected $_jsonApiServers;


    /**
     * @var     string $_stubPath
     */
    protected $_stubPath;


    /**
     * @var     array $_types
     */
    protected $_types;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $types
     *
     * @version     2.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $types)
    {
        $this->_types = $types;

        $this->_stubPath = CodeGenerator::getStubPath('jsonapi');

        $this->_init();
        $this->_process();

    } // __construct()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-04-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_jsonApiNameSpace = config('jsonapi.namespace', config('code-generator.jsonapi-namespace', 'JsonApi'));
        $this->_jsonApiServers = CodeGenerator::getJsonApiServers();

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $types
     *
     * @return      void
     *
     * @version     1.4.0 / 2025-03-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(array $types): void
    {
        new ExceptionHandlerGenerator($types);
        new ServerGenerator($types);
        new RouteGenerator($types);

    } // process()


} // class JsonApiGenerator extends BaseGenerator {}
