<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     2.7.0 / 2025-03-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ActionUpdateGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     string $_modelNamespace
     */
    private $_modelNamespace;


    /**
     * @var     string $_typeNameCamel
     */
    protected $_typeNameCamel;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelActionUpdate->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.2.0 / 2024-12-01
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/action.update.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('model-namespace', $this->_modelNamespace, $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name-camel', $this->_typeNameCamel, $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $packageNamespace.'\\Models';
        $this->_namespace = $packageNamespace.'\\Actions';

        $this->_typeNameCamel = $this->_Type->getBaseName(CaseStyle::Camel, Number::Singular);

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-10-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Action-Klasse schreiben. */
        $this->_filePath = 'Actions/'.$this->_typeName;

        parent::_writeFileContents($this->_Package, 'Update.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ActionUpdateGenerator extends LaravelFileGenerator {}
