<?php
/**
 * Code Generator for Models
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @todo        Visitor     Methode appointments    >   return $this->belongsToMany(Appointment::class)->withPivot('token');
 *
 * @todo        VisitType   Methode appointments(): HasManyThrough dynamisch erzeugen.
 *
 * @todo        Eventuell könnte es sinnvoll sein die Paket-Models zusätzlich noch im Projekt
 *              zu erzeugen. Entweder als eigenständige Models, die dann aber auch die projekt-spezifischen
 *              Relationen beinhalten, oder als Models mit dem Paket-Model als Elternklasse, in dem dann
 *              nur die Relationen-Methoden enthalten sind, die im Paket-Model nicht eingetragen werden
 *              dürfen.
 *              In jedem Fall könnten dann auch die Schema-Klassen auf die lokal vorliegenden Models verweisen.
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Elements\Field;
use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Enums\ModelType;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;
use BplanBase\CodeGenerator\Helpers\StringHelper;
use Exception;
use Illuminate\Support\Str;


/**
 * Code Generator for Models
 *
 * @version     8.0.0 / 2025-05-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ModelGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der Elternklasse.
     *
     * @var     string $_baseClass
     */
    protected $_baseClass;


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias;


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * @var     integer $_castMaxFieldNameLength
     */
    protected $_castMaxFieldNameLength = 0;


    /**
     * @var     array $_casts
     */
    private $_casts = [];


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Models';


    /**
     * @var     array $_fillableFields
     */
    private $_fillableFields = [];


    /**
     * @var     array $_guardedFields
     */
    private $_guardedFields = [];


    /**
     * @var     array $_hiddenFields
     */
    private $_hiddenFields = [];


    /**
     * @var     string $_packageNamespace
     */
    protected $_packageNamespace;


    /**
     * @var     array $_relationFields
     */
    protected $_relationFields = [];


    /**
     * @var     array $_timestamped
     */
    private $_timestamped = false;


    /**
     * @var     array $_unusedTimestamps
     */
    private $_unusedTimestamps = [
        'created_at' => 'CREATED_AT',
        'updated_at' => 'UPDATED_AT',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelModel->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     1.0.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        if ($Type->hasExclude(Generator::LaravelModel)) {
            $this->_exclude = true;
        }
        parent::__construct($Type);

    } // __construct()


    /**
     * Fügt eine Relation hinzu
     *
     * @param       string $methodName
     *
     * @param       string $columnName
     *
     * @param       string $relationType
     *
     * @param       string $targetClass
     *
     * @param       array|null $pivotFields
     *
     * @return      $this
     *
     * @version     3.0.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _addRelation(string $methodName, string $columnName, string $relationType, string $targetClass, array|null $pivotFields = null, null|string $pivotTable = null, null|string $relatedPivotKey = null): self
    {
        $key = strtolower($methodName);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Duplicate relation method ['.$methodName.'()]');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] =
                $this->_relationFields[$key];
            }
            $this->_errors[$key][] = [
                'columnName' => $columnName,
                'methodName' => $methodName,
                'pivotFields' => $pivotFields,
                'relationType' => $relationType,
                'targetClass' => $targetClass,
                'pivotTable' => $pivotTable,
                'relatedPivotKey' => $relatedPivotKey,
            ];
            $key .= 'Failure';

        }
        $this->_relationFields[$key] = [
            'columnName' => $columnName,
            'methodName' => $methodName,
            'pivotFields' => $pivotFields,
            'relationType' => $relationType,
            'targetClass' => $targetClass,
            'pivotTable' => $pivotTable,
            'relatedPivotKey' => $relatedPivotKey,
        ];
        return $this;

    } // _addRelation()


    /**
     * Liest die stub-Datei und ersetzt Platzhalter
     *
     * @return      string Liefert den aufbereiteten Dateiinhalt
     *
     * @version     1.8.0 / 2025-04-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $fileContents = file_get_contents($this->_stubPath.'/model.stub');

            $fileContents = parent::replacePlaceholder('appends', $this->_prepareAppendsArrayReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClass, $fileContents);
            $fileContents = parent::replacePlaceholder('casts', $this->_prepareCastReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('consts', $this->_prepareConstantReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('fillable-fields', $this->_prepareFillableFieldReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('guarded-fields', $this->_prepareGuardedFieldReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('hidden-fields', $this->_prepareHiddenFieldReplacement(), $fileContents);
            $fileContents = parent::replacePlaceholder('timestamped', ($this->_timestamped === true ? 'true' : 'false'), $fileContents);
            $fileContents = parent::replacePlaceholder('table', $this->_tableName, $fileContents);
            $fileContents = parent::replacePlaceholder('traits', $this->_prepareTraitReplacement(), $fileContents);

        } else {
            $fileContents = file_get_contents($this->_stubPath.'/derived.model.stub');

            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClassAlias, $fileContents);
        }
        $fileContents = parent::replacePlaceholder('methods', $this->_prepareMethodReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     * Initialisiert Objektvariablen
     *
     * @return      $this
     *
     * @version     1.10.0 / 2025-04-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_baseClass = $this->_Type->getExtends(self::$_generator)
            ?? (($this->_ModelType === ModelType::Pivot) ? 'Pivot' : 'Model');

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_packageName = $this->_Package->getName();
        $this->_packageNamespace = $this->_Package->getNamespace();
        $this->_namespace = $this->_packageNamespace.'\\Models';

        return $this;

    } // _init()


    /**
     * Initialisiert die use-Anweisungen der Model-Klasse des aktuellen Types
     *
     * @return      $this
     *
     * @version     1.5.0 / 2025-04-12
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            if ($this->_ModelType === ModelType::Model) {
                $this->_addUse('Illuminate\\Database\\Eloquent\\Model');
            } else {
                $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\Pivot');
            }
        }
        $this->_addUse($this->_packageNamespace.'\\Observers\\'.$this->_typeName.'Observer');
        $this->_addUse('Illuminate\\Database\\Eloquent\\Attributes\\ObservedBy');

        return parent::_prepareUses();

    } // _initUses()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "appends" auf
     *
     * @return      string
     *
     * @version     1.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareAppendsArrayReplacement(): string
    {
        $appends = $this->_Type->getAppends();

        $replacement = '';

        if (!empty($appends)) {
            ksort($appends);
            /*
            **  Ersetzungs-String für die Append-Definition zusammenstellen. */
            $hasOne = false;
            $padding = str_repeat(' ', 8);

            foreach ($appends as $append) {
                $generator = self::$_generator.'.array';

                if (!isset($append['generators'][$generator])) {
                    continue;
                }
                $replacement .= "\n".$padding.'\''.$append['field'].'\',';
                $hasOne = true;
            }
            if ($hasOne === true) {
                $replacement .= "\n".str_repeat(' ', 4);
            }
        }
        return $replacement;

    } // _prepareAppendsArrayReplacement()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "casts" auf
     *
     * @return      string
     *
     * @version     1.0.1 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareCastReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_casts)) {
            ksort($this->_casts);
            /*
            **  Ersetzungs-String für die Cast-Definition zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_casts as $field => $type) {
                $replacement .= "\n".$padding.str_pad('\''.$field.'\'', $this->_castMaxFieldNameLength + 2, ' ', STR_PAD_RIGHT).' => \''.$type.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareCastReplacement()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "consts" auf
     *
     * @return      string
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareConstantReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_unusedTimestamps)) {
            ksort($this->_unusedTimestamps);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 4);

            foreach ($this->_unusedTimestamps as $constant) {
                $replacement .= "\n".$padding.'/**'
                    ."\n".$padding.' *'
                    ."\n".$padding.' */'
                    ."\n".$padding.'const '.$constant.' = null;';
            }
            $replacement .= "\n\n";
        }
        return $replacement;

    } // _prepareConstantReplacement()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "fillable-fields" auf
     *
     * @return      string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareFillableFieldReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_fillableFields)) {
            ksort($this->_fillableFields);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_fillableFields as $field) {
                $replacement .= "\n".$padding.'\''.$field.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareFillableFieldReplacement()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "guarded-fields" auf
     *
     * @return      string
     *
     * @version     1.0.0 / 2024-10-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareGuardedFieldReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_guardedFields)) {
            ksort($this->_guardedFields);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_guardedFields as $field) {
                $replacement .= "\n".$padding.'\''.$field.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareGuardedFieldReplacement()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "hidden-fields" auf
     *
     * @return      string
     *
     * @version     1.0.0 / 2024-10-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _prepareHiddenFieldReplacement(): string
    {
        $replacement = '';

        if (!empty($this->_hiddenFields)) {
            ksort($this->_hiddenFields);
            /*
            **  Ersetzungs-String für die Use-Statements zusammenstellen. */
            $padding = str_repeat(' ', 8);

            foreach ($this->_hiddenFields as $field) {
                $replacement .= "\n".$padding.'\''.$field.'\',';
            }
            $replacement .= "\n".str_repeat(' ', 4);
        }
        return $replacement;

    } // _prepareHiddenFieldReplacement()


    /**
     * Bereitet den Ersetzungs-String für den Platzhalter "methods" auf
     *
     * @return      string
     *
     * @version     1.7.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareMethodReplacement(): string
    {
        ksort($this->_relationFields);
        /*
        **  Ersetzungen für die Relationen-Methoden zusammenstellen. */
        $replacements = [];
        /*
        **  Relationen verarbeiten.
        **
        **                 related-class
        **                 |         through-class
        **                 |         |         pivot-table
        **                 |         |         |       column            related-pivot-key
        **                 |         |         |       |                 |
        **  belongsTo      $related, |         |       $foreignKey,      $ownerKey,                                   $relation)
        **  belongsToMany  $related, |         $table, $foreignPivotKey, $relatedPivotKey, $parentKey, $relatedKey,   $relation)
        **  hasMany        $related, |                 $foreignKey,      $localKey)
        **  hasManyThrough $related, $through,         $firstKey,        $secondKey,       $localKey, $secondLocalKey)
        **  hasOne         $related,                   $foreignKey,      $localKey)
        **  hasOneThrough  $related, $through,         $firstKey,        $secondKey,       $localKey, $secondLocalKey)
        **
        */
        foreach ($this->_relationFields as $relation) {
            $relationType = $relation['relationType'];
            $methodName = $relation['methodName'];

            $withPivot = '';

            if (!empty($relation['pivotFields'])) {
                $withPivot = '->withPivot('."'".implode("', '", $relation['pivotFields'])."'".')';
            }
            $fileContents = file_get_contents($this->_stubPath.'/snippets/model/method.'.$relationType.'.stub');

            $fileContents = parent::replacePlaceholder('column', $relation['columnName'], $fileContents);
            $fileContents = parent::replacePlaceholder('method', $methodName, $fileContents);
            $fileContents = parent::replacePlaceholder('pivot-table', $relation['pivotTable'] ?? '', $fileContents);
            $fileContents = parent::replacePlaceholder('related-class', $relation['targetClass'].'::class', $fileContents);
            $fileContents = parent::replacePlaceholder('related-pivot-key', $relation['relatedPivotKey'] ?? '', $fileContents);
            $fileContents = parent::replacePlaceholder('with-pivot', $withPivot, $fileContents);

            $replacements[$methodName] = $fileContents;
        }
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $appends = $this->_Type->getAppends();

            if (!empty($appends)) {
                ksort($appends);
                /*
                **  Ersetzungs-String für die Attribute-Methoden zusammenstellen. */
                foreach ($appends as $append) {
                    $generator = self::$_generator.'.method';

                    if (!isset($append['generators'][$generator])) {
                        continue;
                    }
                    $methodName = 'get'.Str::studly($append['field']).'Attribute';

                    $fileContents = file_get_contents($this->_stubPath.'/snippets/model/method.get-attribute-method.stub');

                    $fileContents = parent::replacePlaceholder('method', $methodName, $fileContents);
                    $fileContents = parent::replacePlaceholder('return', $append['return'], $fileContents);

                    $replacements[$methodName] = $fileContents;
                }
            }
        }
        ksort($replacements);

        return implode('', $replacements);

    } // _prepareMethodReplacement()


    /**
     * Startet die Verarbeitung des aktuellen Types
     *
     * @return      $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processType();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     * Verarbeitet die BackReferences zum aktuellen Type
     *
     * @throws      Exception
     *
     * @return      $this
     *
     * @version     1.13.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getAttribute('columnName');

                $pivotAppendFields = null;
                $pivotTable = null;
                $relatedPivotKey = null;

                $RelatedType = $BackReference->getRelatedType();

                if ($BackReference->getModelType() === ModelType::Pivot) {
                    $pivotTables = $RelatedType->getPivotTables();

                    if (isset($pivotTables[$this->_tableName])) {
                        $Type = CodeGenerator::getType($pivotTables[$this->_tableName]);

                        $pivotAppendFields = $RelatedType->getPivotAppendFields();
                        $relationType = 'BelongsToMany';
                        /*
                        **  Name der Zwischentabelle ermitteln. */
                        $pivotTable = $RelatedType->getAttribute('tableName');
                        /*
                        **  Lokales Feld und den Schlüssel zur entfernten Tabelle tauschen, */
                        $relatedPivotKey = $columnName;
                        $columnName = $RelatedType->getRelatedPivotField($relatedPivotKey);

                        $foreignKey = $RelatedType->getForeignKey($relatedPivotKey);

                    } else {
                        /*
                        **  Dieser Fall dürfte eigentlich nie eintreten. */
                        throw new Exception('Undefined pivot table "'.$this->_tableName.'".');
                    }
                } else {
                    $Type = $BackReference->getRelatedType();

                    $relationType = 'HasMany';
                    /*
                        todo    Prüfen wie hier abgefangen werden kann, dass bei Tabellen mit einem
                                Präfix das Präfix auch in den Methodennamen übernommen wird.
                                Die Lösung für das Problem müsste dann analog auch bei den Routen
                                angewendet werden.
                    */
                    $foreignKey = $RelatedType->getForeignKey($columnName);
                }
                $methodName = $Type->getBaseName(CaseStyle::Camel, Number::Plural);
                $targetClass = $Type->getBaseName(CaseStyle::Studly, Number::Singular);

                if (!empty($foreignKey['reverseRelationName'])) {
                    // TODO
                    $methodName = Str::camel($foreignKey['reverseRelationName']);
                }
                if (!empty($foreignKey['reverseRelationType'])) {
                    $relationType = StringHelper::reformat($foreignKey['reverseRelationType'], CaseStyle::Studly);

                    if ($relationType === 'HasOne') {
                        /*
                        **  Normalerweise sind die hier verarbeiteten Relationen ("BelongsToMany" und "HasMany")
                        **  immer "1 zu viele"-Relationen. Für den Fall, dass aber explizit der Typ "HasOne"
                        **  eingesetzt wird, muss der Methodenname angepasst werden. */
                        $methodName = Str::singular($methodName);
                    }
                }
                if ($this->_GeneratorMode === GeneratorMode::Default) {
                   /*
                   **  Zum Projekt selbst werden alle Relationen hinzugefügt. */
                   if ($this->_PackageType === PackageType::Project) {
                       $this->_addRelation($methodName, $columnName, $relationType, $targetClass, $pivotAppendFields, $pivotTable, $relatedPivotKey);
                       $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\'.$relationType);

                   } else {
                       /*
                       **  Auf Paket-Ebene werden Rückwärts-Relationen nur innerhalb des Pakets hinzugefügt. */
                       if ($this->_packageName === $RelatedType->getPackage()?->getName()) {
                           $this->_addRelation($methodName, $columnName, $relationType, $targetClass, $pivotAppendFields, $pivotTable, $relatedPivotKey);
                           $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\'.$relationType);
                       }
                   }
                } else {
                    /*
                    **  Relationen werden nur dann hinzugefügt, wenn der RelatedType zu einem
                    **  anderen Paket gehört. */
                    if ($this->_originalPackageName !== $RelatedType->getPackage()?->getName()) {
                        $this->_addRelation($methodName, $columnName, $relationType, $targetClass, $pivotAppendFields, $pivotTable, $relatedPivotKey);
                        $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\'.$relationType);
                    }
                }
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     * Verarbeitet die Fields zum aktuellen Type
     *
     * @return      $this
     *
     * @version     1.2.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processFields(): self
    {
        /*
        **  Fields abarbeiten. */
        foreach ($this->_Fields as $Field) {
            $columnName = $Field->getAttribute('columnName');
            $type = $Field->getAttribute('type');

            if ($Field->getAttribute('autoIncrement') === true) {
                continue;
            }
            switch ($columnName) {
                case 'deleted_at':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'datetime';
                    $this->_guardedFields[$columnName] = $columnName;

                    $this->_addTrait('Illuminate\\Database\\Eloquent\\SoftDeletes');

                    continue 2;
                    break;

                case 'created_at':
                case 'updated_at':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'datetime';
                    $this->_guardedFields[$columnName] = $columnName;
                    $this->_timestamped = true;

                    unset($this->_unusedTimestamps[$columnName]);

                    continue 2;
                    break;

                case 'uuid':
                    /*
                    **  uuid-Felder sind implizit immer "guarded" (null|true), außer sie wurden explizit
                    **  auf FALSE gesetzt. */
                    if ($Field->getAttribute('guarded') !== false) {
                        $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                        $this->_guardedFields[$columnName] = $columnName;

                        continue 2;
                        break;
                    }
            }
            switch ($type) {
                case 'boolean':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'boolean';
                    break;

                case 'date':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'date';
                    break;

                case 'json':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'object';
                    break;

                case 'timestamp':
                    $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($columnName));
                    $this->_casts[$columnName] = 'datetime';
                    break;
            }
            if ($Field->isForeignKey() === true) {
                $this->_processForeignKey($Field);
            }
            if ($Field->getAttribute('guarded') === true) {
                $this->_guardedFields[$columnName] = $columnName;
            } else {
                $this->_fillableFields[$columnName] = $columnName;
            }
            if ($Field->getAttribute('hidden') === true) {
                $this->_hiddenFields[$columnName] = $columnName;
            }
            if (($individualCast = $Field->getAttribute('cast')) !== null) {
                $this->_castMaxFieldNameLength = max($this->_castMaxFieldNameLength, strlen($individualCast));
                $this->_casts[$columnName] = $individualCast;
            }
        }
        return $this;

    } // _processFields()


    /**
     * Verarbeitet die ForeignKeys zum aktuellen Type
     *
     * @param       Field $Field
     *
     * @return      $this
     *
     * @version     1.1.0 / 2025-03-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processForeignKey(Field $Field): self
    {
        $columnName = $Field->getAttribute('columnName');

        $RelatedType = $Field->getRelatedType();
        $RelatedPackage = $RelatedType->getPackage();

        $methodName = $Field->getAttribute('relationName', CaseStyle::Camel);
        $targetClass = $RelatedType->getBaseName(CaseStyle::Studly, Number::Singular);

        $this->_addRelation($methodName, $columnName, 'BelongsTo', $targetClass);
        $this->_addUse('Illuminate\\Database\\Eloquent\\Relations\\BelongsTo');
        /*
        **  Prüfen, ob das Package, für das die aktuelle Model-Klasse erstellt wird, zu einem
        **  anderen Package gehört als das Model, zu dem die Relation erstellt werden soll.

            todo    Prüfen ob das hier so richtig ist.
                    Möglicherweise dürfen nur im Projekt selbst die zusätzlichen Use-Anweisungen
                    eingefügt werden. Wenn allerdings ein externes Paket eine feste Abhängigkeit
                    zu einem anderen externen Paket hat, dann könnte das hier so richtig sein.
        */
        if ($this->_Package->comparePackage($RelatedPackage->getName()) === false) {
            /*
            **  Für Models aus externen Paketen müssen zusätzliche use-Anweisungen im
            **  Projekt-Model angelegt werden. */
            $this->_addUse($RelatedPackage->getNamespace().'\\Models\\'.$targetClass);
        }
        return $this;

    } // _processForeignKey()


    /**
     * Initiiert die Aufbereitung der einzelnen Komponenten des aktuellen Types
     *
     * @return      $this
     *
     * @version     1.1.0 / 2025-04-12
     * @history     ModelGenerator::_processTypeDefinition(), 1.5.0 / 2025-02-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processType(): self
    {
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $this->_processFields();
        }
        $this->_processBackReferences();
        $this->_initTraits();
        $this->_initUses();

        return $this;

    } // _processType()


    /**
     *
     * @return      $this
     *
     * @version     1.3.0 / 2025-04-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Model-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'.php', $fileContents);

        if ($this->_PackageType === PackageType::Package) {
            new DerivedModelGenerator($this->_Type);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ModelGenerator extends LaravelFileGenerator {}
