<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     3.0.0 / 2025-05-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ObserverGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias;


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Observers';


    /**
     * @var     string $_modelNamespace
     */
    protected $_modelNamespace;


    /**
     * @var     string $_packageNamespace
     */
    protected $_packageNamespace;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelObserver->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     1.0.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        if ($Type->hasExclude(Generator::LaravelObserver)) {
            $this->_exclude = true;
        }
        parent::__construct($Type);

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.6.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $fileContents = file_get_contents($this->_stubPath.'/observer.stub');

            $methodContents = '//';
            /*
            **  Wenn es ein Feld "uuid" gibt, dann wird es automatisch gefüllt. */
            if ($this->_Type->hasField('uuid')) {
                $this->_addUse('Illuminate\\Support\\Str');

                $methodContents = '$Model->uuid = Str::uuid();'
                    ."\n";
            }
            $fileContents = parent::replacePlaceholder('creating-method', $methodContents, $fileContents);

        } else {
            $fileContents = file_get_contents($this->_stubPath.'/derived.observer.stub');

            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClassAlias, $fileContents);
        }
        $fileContents = parent::replacePlaceholder('model-namespace', $this->_modelNamespace, $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-04-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $this->_packageNamespace.'\\Models';
        $this->_namespace = $this->_packageNamespace.'\\Observers';

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-04-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse($this->_modelNamespace.'\\'.$this->_typeName);

        return parent::_prepareUses();

    } // _initUses()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-18
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.3.0 / 2025-04-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Observer-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Observer.php', $fileContents);

        if ($this->_PackageType === PackageType::Package) {
            new DerivedObserverGenerator($this->_Type);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ObserverGenerator extends LaravelFileGenerator {}
