<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\BaseControllerGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\BaseSeederGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     1.1.0 / 2025-03-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LaravelGenerator extends BaseGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_stubPath
     */
    protected $_stubPath;


    /**
     * @var     array $_types
     */
    protected $_types;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $types
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $types)
    {
        $this->_types = $types;

        $this->_stubPath = CodeGenerator::getStubPath('laravel');

        $this->_init();
        $this->_process();

    } // __construct()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $type
     *
     * @return      void
     *
     * @version     1.2.0 / 2025-04-13
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(array $types): void
    {
        //  todo    Verlagern nach onBeforeMigrate ???
        new BaseControllerGenerator($types);
        new BaseSeederGenerator($types);

    } // process()


} // class LaravelGenerator extends BaseGenerator {}
