<?php
/**
 * Code Generator Package Element Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Elements
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Elements;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Helpers\StringHelper;


/**
 * Code Generator Package Element Class
 *
 * @version     10.0.0 / 2025-04-05
 * @history     Definitions\Package, 2.0.0 / 2025-02-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Package
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     array $_authors
     */
    private $_authors;


    /**
     * @var     string $_baseDir
     */
    private $_baseDir = 'src';


    /**
     * @var     string $_basePath
     */
    private $_basePath;


    /**
     * @var     string $_copyright
     */
    private $_copyright;


    /**
     * @var     string $_devStart
     */
    private $_devStart;


    /**
     * @var     bool $_isProject
     */
    private $_isProject = false;


    /**
     * @var     string $_name
     */
    private $_name;


    /**
     * @var     string $_namespace
     */
    private $_namespace;


    /**
     * @var     string $_packageName
     */
    private $_packageName;


    /**
     * @var     string $_prefix
     */
    private $_prefix;


    /**
     * @var     PackageType $_Type
     */
    private $_Type;


    /**
     * @var     bool $_usePrefix
     */
    private $_usePrefix = false;


    /**
     * @var     string $_vendorName
     */
    private $_vendorName;


    /**
     * @var     float $_version
     */
    private $_version = 1.0;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $settings
     *
     * @version     1.2.0 / 2025-04-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(array $settings)
    {
        $this->_devStart = date('Y');

        foreach ($settings as $key => $value) {
            $this->{'_'.$key} = $value;
        }
        /*
        **  Workaround für Konfigurationsdateien < Version 1.2
        **  Bis dahin war nur ein einzelner Autor im Schlüssel "author" möglich. */
        if ($this->_authors === null) {
            $this->_authors = [
                $this->_author
            ];
        }
        $this->_Type = ($this->_isProject) ? PackageType::Project : PackageType::Package;

    } // __construct()


    /**
     * Vergleicht das übergebene Package mit dem aktuellen Package-Objekt
     *
     * @param       Package|string $package
     *              Wahlweise ein Package-Objekt oder der Name eines Pakets.
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-03-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function comparePackage(Package|string $package): bool
    {
        if ($package instanceof Package) {
            return $this->_name === $package->getName();
        }
        return $this->_name === $package;

    } // comparePackage()


    /**
     * Liefert die Autorennamen
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-04-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getAuthors(): array
    {
        return $this->_authors;

    } // getAuthors()


    /**
     * Liefert den Namen des Verzeichnisses in dem die Klassen gespeichert werden
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getBaseDir(): string
    {
        return $this->_baseDir;

    } // getBaseDir()


    /**
     * Liefert den Pfad zum Wurzelverzeichnis
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getBasePath(): string
    {
        return $this->_basePath;

    } // getBasePath()


    /**
     * Liefert den Copyright-String
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-03-21
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getCopyright(): string
    {
        return $this->_copyright;

    } // getCopyright()


    /**
     * Liefert das Startjahr der Entwicklung des aktuellen Packages
     *
     * @return      int
     *
     * @version     1.1.0 / 2025-03-21
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getDevStart(): int
    {
        return (int) $this->_devStart;

    } // getDevStart()


    /**
     * Liefert den Namen des aktuellen Packages
     *
     * @return      null|string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getName(): null|string
    {
        return $this->_name;

    } // getName()


    /**
     * Liefert den Namespace des aktuellen Packages
     *
     * @return      null|string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getNamespace(): null|string
    {
        return $this->_namespace;

    } // getNamespace()


    /**
     * Liefert den reinen Paketnamen
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPackageName(): string
    {
        return $this->_packageName;

    } // getPackageName()


    /**
     * Liefert das Präfix des aktuellen Packages
     *
     * @return      null|string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPrefix(): null|string
    {
        return $this->_prefix;

    } // getPrefix()


    /**
     * Liefert den Typ des Packages
     *
     * @return      PackageType
     *
     * @version     1.0.0 / 2025-04-05
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getType(): PackageType
    {
        return $this->_Type;

    } // getType()


    /**
     * Liefert den Vendor-Namen
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getVendorName(): string
    {
        return $this->_vendorName;

    } // getVendorName()


    /**
     * Liefert die Version aus der Package-Konfiguration
     *
     * @return      float
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getVersion(): float
    {
        return $this->_version;

    } // getVersion()


    /**
     * Liefert die Information, ob das aktuelle Objekt zum Projekt oder zu einem Package gehört
     *
     * @return      bool
     *
     * @version     1.0.0 / 2025-03-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function isForProject(): bool
    {
        return $this->_isProject === true;

    } // isForProject()


    /**
     * Bereitet die übergebene Zeichenkette für den Einsatz als BaseName auf
     *
     * Der BaseName ist DER Wert, aus dem sämtliche Benennungen (Klassen- und Relationennamen,
     * Ressourcenbezeichnungen usw.) gebildet werden. Er ist immer singular und im CaseStyle
     * "slug". Außerdem ist er mit dem Package-/Projekt-Präfix versehen, wenn die Einstellungen
     * des Pakets/Projekts es erfordern.
     *
     * @param       string $sourceString
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function prepareBaseName(string $sourceString): string
    {
        $sourceString = StringHelper::reformat($sourceString, CaseStyle::Slug, Number::Singular);

        if (!empty($this->_prefix)) {
            if ($this->_usePrefix === true) {
                /*
                **  Wenn ein Prefix verwendet werden soll, dann wird es hinzugefügt, sofern es nicht
                **  bereits vorhanden ist. */
                if (stripos($sourceString, $this->_prefix) !== 0) {
                    $sourceString = $this->_prefix.'-'.$sourceString;
                }
            } else {
                /*
                **  Wenn kein Prefix verwendet werden soll, dann wird es entfernt, sollte es bereits
                **  exisitieren. */
                if (stripos($sourceString, $this->_prefix) === 0) {
                    $sourceString = substr($sourceString, strlen($this->_prefix) + 1);
                }
            }
        }
        return $sourceString;

    } // prepareBaseName()


    /**
     * Liefert die Information, ob für das aktuelle Package das Präfix genutzt werden soll
     *
     * @return      float
     *
     * @version     1.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function usePrefix(): bool
    {
        return $this->_usePrefix;

    } // usePrefix()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Package {}
