<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Enums;


/**
 * Enum Class
 *
 * @version     14.0.0 / 2025-05-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum Generator: string {

    case CodeGeneratorInit        = 'code-generator.init';

    case CSharpJsonApiSerializer  = 'csharp.jsonapiserializer';

    case CSharpNewtonsoftJsonApi  = 'csharp.newtonsoftjsonapi';

    case CSharpNewtonsoftJson     = 'csharp.newtonsoft';

    case JsonApiDerivedPolicy     = 'jsonapi.derived.policy';

    case JsonApiDerivedRequest    = 'jsonapi.derived.request';

    case JsonApiDerivedSchema     = 'jsonapi.derived.schema';

    case JsonApiExceptionHandler  = 'jsonapi.exception-handler';

    case JsonApiPolicy            = 'jsonapi.policy';

    case JsonApiRequest           = 'jsonapi.request';

    case JsonApiRoute             = 'jsonapi.route';

    case JsonApiSchema            = 'jsonapi.schema';

    case JsonApiServer            = 'jsonapi.server';

    case LaravelActionCreate      = 'laravel.action.create';

    case LaravelActionDelete      = 'laravel.action.delete';

    case LaravelActionUpdate      = 'laravel.action.update';

    case LaravelBaseController    = 'laravel.base-controller';

    case LaravelBaseSeeder        = 'laravel.base-seeder';

    case LaravelController        = 'laravel.controller';

    case LaravelDerivedModel      = 'laravel.derived.model';

    case LaravelDerivedObserver   = 'laravel.derived.observer';

    case LaravelDerivedRepository = 'laravel.derived.repository';

    case LaravelDerivedService    = 'laravel.derived.service';

    case LaravelFormRequestStore  = 'laravel.form-request.store';

    case LaravelFormRequestUpdate = 'laravel.form-request.update';

    case LaravelModel             = 'laravel.model';

    case LaravelObserver          = 'laravel.observer';

    case LaravelRepository        = 'laravel.repository';

    case LaravelService           = 'laravel.service';

    case LaravelUserMigration     = 'laravel.user.migration';

    case LivewireIndex            = 'livewire.index';

    case LivewireModalAdd         = 'livewire.modal.add';

    case LivewireModalEdit        = 'livewire.modal.edit';

    case WinMerge                 = 'winmerge';

} // enum Generator {}
