<?php
/**
 * JasonApi Code Generator Class
 *
 * @todo        Fehlermeldung bei doppelten Relationen
 *
 * @todo        UserSchema          currentTeamId
 *
 * @todo        Methode _processAdditionalRelations()   >   Relationentyp prüfen
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Elements\Field;
use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Enums\ModelType;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApiFileGenerator;
use BplanBase\CodeGenerator\Helpers\StringHelper;
use Exception;
use Illuminate\Support\Str;


/**
 * JasonApi Code Generator Class
 *
 * @version     6.6.0 / 2025-04-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SchemaGenerator extends JsonApiFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias;


    /**
     * @var     array $_appends
     */
    protected $_appends = [];


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     string $_idField
     */
    protected $_idField;


    /**
     * @var     string $_packageName
     */
    protected $_packageName;


    /**
     * @var     string $_packageNamespace
     */
    protected $_packageNamespace;


    /**
     * @var     array $_regularFields
     */
    protected $_regularFields = [];


    /**
     * @var     array $_relationFields
     */
    protected $_relationFields = [];


    /**
     * @var     array $_technicalFields
     */
    protected $_technicalFields = [];


    /**
     * @var     string $_timezone
     */
    protected $_timezoneReplacement = '';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiSchema->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $methodName
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-11-03
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _addRelation(string $name, string $type, string $resourceName): self
    {
        $key = strtolower($name);

        if (isset($this->_relationFields[$key])) {
            CodeGenerator::addError(self::$_generator, $this->_typeName, 'Multiple relations ['.$type.' '.$name.']');

            if (empty($this->_errors[$key])) {
                $this->_errors[$key][] =
                $this->_relationFields[$key];
            }
            $this->_errors[$key][] = [
                'name' => $name,
                'resourceName' => $resourceName,
                'type' => $type,
            ];
            $key .= '-failure';
            $name .= '-failure';

        }
        $this->_relationFields[$key] = [
            'name' => $name,
            'resourceName' => $resourceName,
            'type' => $type,
        ];
        return $this;

    } // _addRelation()


    /**
     *
     * @return 	    string
     *
     * @version     1.5.0 / 2025-04-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $fileContents = file_get_contents($this->_stubPath.'/schema.stub');

        } else {
            $fileContents = file_get_contents($this->_stubPath.'/derived.schema.stub');

            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClassAlias, $fileContents);
        }
        $fileContents = parent::replacePlaceholder('fields', $this->_prepareFieldReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('timezone', $this->_timezoneReplacement, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.10.0 / 2025-04-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();
        /*
        **  Hier müssen die Server aus dem Type - und nicht die aus der Konfiguration - verwendet
        **  werden, weil der Aktivierungsstatus möglicherweise geändert ist. */
        $this->_jsonApiServers = $this->_Type->getJsonApiServers();

        $this->_packageNamespace = $this->_Package->getNamespace();
        $modelNamespace = $this->_packageNamespace.'\\Models';

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_namespace = $this->_packageNamespace.'\\'.$this->_jsonApiNameSpace;

        $this->_addUse($modelNamespace.'\\'.$this->_typeName);

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.5.0 / 2025-04-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse([
            'Illuminate\\Database\\Eloquent\\Builder',
            'Illuminate\\Http\\Request',
            'LaravelJsonApi\\Eloquent\\Contracts\\Paginator',
            'LaravelJsonApi\\Eloquent\\Filters\\WhereIdIn',
            'LaravelJsonApi\\Eloquent\\Pagination\\PagePagination',
        ]);
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $this->_addUse('LaravelJsonApi\\Eloquent\\Schema');
        }
        return parent::_prepareUses();

    } // _initUses()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.4.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareFieldReplacement(): string
    {
        /*
        **  Ersetzungs-String für die Felddefinitionen zusammenstellen. */
        $padding = str_repeat(' ', 12);
        $replacement = '';

        if ($this->_idField !== null) {
            $replacement .= "\n".$padding.$this->_idField;
        }
        if (!empty($this->_technicalFields)) {
            ksort($this->_technicalFields);

            $replacement .= "\n";

            foreach ($this->_technicalFields as $field) {
                $replacement .= "\n".$padding.$field;
            }
        }
        if (!empty($this->_regularFields)) {
            ksort($this->_regularFields);

            $replacement .= "\n";

            foreach ($this->_regularFields as $key => $field) {
                $replacement .= "\n".$padding.$field;
            }
        }
        if (!empty($this->_appends)) {
            $replacement .= "\n".$padding.'/*'
                ."\n".$padding.'**  Appended fields */';

            foreach ($this->_appends as $appendField) {
                $replacement .= "\n".$padding.$appendField;
            }
        }
        if (!empty($this->_relationFields)) {
            /*
            **  Relationen-Felder abarbeiten. */
            ksort($this->_relationFields);

            $replacement .= "\n".$padding.'/*'
                ."\n".$padding.'**  Relations */';

            foreach ($this->_relationFields as $relation) {
                $replacement .= "\n".$padding.$relation['type'].'::make(\''.$relation['name'].'\')->type(\''.$relation['resourceName'].'\')->serializeUsing('
                    ."\n".$padding.'    static fn($Relation) => $Relation->alwaysShowData()'
                    ."\n".$padding.'),';
            }
        }
        $replacement .= "\n";

        return $replacement;

    } // _prepareFieldReplacement()


    /**
     *
     * @param       Field $Field
     *
     * @return 	    string
     *
     * @version     3.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareRegularField(Field $Field): string
    {
        $columnName = $Field->getAttribute('name');
        $nameCamelCase = $Field->getAttribute('name', CaseStyle::Camel);

        $addNewline = '';
        $basePadding = str_repeat(' ', 8);
        $padding = str_repeat(' ', 12);

        switch ($Field->getAttribute('abstractType')) {
            case 'bool':
                $field = 'Boolean::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Boolean');
                break;

            case 'datetime':
                /*
                **  Sonderbehandlung für die Felder "created_at", "deleted_at" und "updated_at".
                **  Diese Felder sind automatisch "readOnly" und "sortable", sofern in der Migration keine
                **  abweichende Einstellung vorgenommen wurde. */
                if (Field::isTechnicalField($columnName)) {
                    $Field->setAttribute('hidden', $Field->getAttribute('hidden') ?? true);
                    $Field->setAttribute('readOnly', $Field->getAttribute('readOnly') ?? true);
                    $Field->setAttribute('sortable', $Field->getAttribute('sortable') ?? true);
                }
                $addNewline = "\n";

                $field = 'DateTime::make(\''.$nameCamelCase.'\')->serializeUsing('
                    ."\n".$padding.'    static fn($value) => $value ? Carbon::parse($value)->setTimezone($timezone)->format(\'c\') : null'
                    ."\n".$padding.')';

                $this->_timezoneReplacement = "\n"
                    ."\n".$basePadding.'$timezone = config(\'app.timezone\');'
                    ."\n";

                $this->_addUse('Carbon\\Carbon');
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\DateTime');
                break;

            case 'string':
                if ($Field->getAttribute('type') === 'json') {
                    $jsonType = 'Array'.($Field->getAttribute('jsonType') ?? CodeGenerator::JSON_TYPE_ARRAY);

                    $field = $jsonType.'::make(\''.$nameCamelCase.'\')';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\'.$jsonType);

                } else {
                    $field = 'Str::make(\''.$nameCamelCase.'\')';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
                }
                break;

            case 'integer':
                $field = 'Number::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Number');
                break;

            default:
                $field = 'Str::make(\''.$nameCamelCase.'\')';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
        }
        if ($Field->getAttribute('hidden') === true) {
            $field .= '->hidden()';
        }
        if ($Field->getAttribute('readOnly') === true) {
            $field .= '->readOnly()';
        }
        if ($Field->getAttribute('sortable') === true) {
            $field .= '->sortable()';
        }
        $field .= ','.$addNewline;

        return $field;

    } // _prepareRegularField()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processType();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processAdditionalRelations(): self
    {
        /*
        **  Zusätzliche Relationen abarbeiten. */
        foreach ($this->_Type->getAdditionalRelations() as $additionalRelation) {
            $relationName = $additionalRelation['relationName'];
            $relationType = $additionalRelation['relationType'];
            $resourceName = $additionalRelation['resourceName'];
// @todo    Relationentyp prüfen
            if ($relationType === 'HasManyThrough') {
                $relationType = 'HasMany';
            }
            $this->_addRelation($relationName, $relationType, $resourceName);

            $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);
        }
        return $this;

    } // _processAdditionalRelations()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processAppendFields(): self
    {
        $appends = $this->_Type->getAppends();

        if (!empty($appends)) {
            ksort($appends);
            /*
            **  Ersetzungs-String für die Attribute-Methoden zusammenstellen. */
            foreach ($appends as $append) {
                $generator = self::$_generator;

                if (!isset($append['generators'][$generator])) {
                    continue;
                }
                $field = Str::camel($append['field']);
                /*
                **  Appends-Felder werden der Einfahheit halber immer als String-Felder angelegt. Bisher gab es
                **  noch keinen Grund die Felder spezieller zu definieren. */
                $this->_appends[] = 'Str::make(\''.$field.'\'),';

                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Str');
            }
        }
        return $this;

    } // _processAppendFields()


    /**
     *
     * @return 	    $this
     *
     * @version     1.10.0 / 2025-04-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processBackReferences(): self
    {
        $backReferences = CodeGenerator::getBackReferences($this->_tableName);

        if ($backReferences !== null) {
            /*
            **  HasMany- und BelongsToMany-Relationen aufbereiten. */
            foreach ($backReferences as $BackReference) {
                $columnName = $BackReference->getAttribute('columnName');

                $RelatedType = $BackReference->getRelatedType();

                if ($BackReference->getModelType() === ModelType::Pivot) {
                    $pivotTables = $RelatedType->getPivotTables();

                    if (isset($pivotTables[$this->_tableName])) {
                        $Type = CodeGenerator::getType($pivotTables[$this->_tableName]);

                        $resourceName = $Type->getBaseName(CaseStyle::Slug, Number::Plural);
                        $relationType = 'BelongsToMany';

                    } else {
                        /*
                        **  Dieser Fall dürfte eigentlich nie eintreten. */
                        throw new Exception('Undefined pivot table "'.$this->_tableName.'".');
                    }
                } else {
                    $resourceName = $RelatedType->getBaseName(CaseStyle::Slug, Number::Plural);
                    $relationType = 'HasMany';
                }
                $foreignKey = $RelatedType->getForeignKey($columnName);

                if ($foreignKey !== null && !empty($foreignKey['reverseRelationName'])) {
                    $relationName = $foreignKey['reverseRelationName'];
                } else {
                    $relationName = $resourceName;
                }
                if (!empty($foreignKey['reverseRelationType'])) {
                    $relationType = StringHelper::reformat($foreignKey['reverseRelationType'], CaseStyle::Studly);

                    if ($relationType === 'HasOne') {
                        /*
                        **  Normalerweise sind die hier verarbeiteten Relationen ("BelongsToMany" und "HasMany")
                        **  immer "1 zu viele"-Relationen. Für den Fall, dass aber explizit der Typ "HasOne"
                        **  eingesetzt wird, muss der Methodenname angepasst werden. */
                        $relationName = Str::singular($relationName);
                    }
                }
                /*
                **  Zum Projekt selbst werden alle Relationen hinzugefügt. */
                if ($this->_PackageType === PackageType::Project || $this->_GeneratorMode === GeneratorMode::Derived) {
                    $this->_addRelation($relationName, $relationType, $resourceName);
                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);

                } else {
                    /*
                    **  Auf Paket-Ebene werden Rückwärts-Relationen nur innerhalb des Pakets hinzugefügt. */
                    if ($this->_packageName === $RelatedType->getPackage()?->getName()) {
                        $this->_addRelation($relationName, $relationType, $resourceName);
                        $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\'.$relationType);
                    }
                }
            }
        }
        return $this;

    } // _processBackReferences()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-16
     * @history     SchemaGenerator::_processTypeDefinition(), 1.4.0 / 2024-12-30
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _processType(): self
    {
        /*
        **  Felddefinitionen zusammenstellen. */
        foreach ($this->_Fields as $Field) {
            $columnName = $Field->getAttribute('name', CaseStyle::Snake);
            $nameCamelCase = $Field->getAttribute('name', CaseStyle::Camel);
            /*
                todo    Sonderfall berücksichtigen:
                        Der Primary-Key id kann unter Umständen kein AutoIncrement sein, wenn er
                        ein Foreign-Key auf eine andere Tabelle ist.
            */
            if ($Field->getAttribute('autoIncrement') === true) {
                if ($columnName === 'id') {
                    $this->_idField = 'ID::make(),';
                } else {
                    $this->_idField = 'ID::make(\''.$nameCamelCase.'\')';
                }
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\ID');

                continue;
            }
            /*
            **  Foreign-Keys abarbeiten. */
            if ($Field->isForeignKey() === true) {
                if ($columnName === 'id' && $this->_idField === null) {
                    /*
                    **  Das berücksichtigt den Fall, dass die ID keine klassische AutoIncrement-Spalte
                    **  sondern ein Foreign-Key zu einer anderen Tabelle ist (z.B. UserRecord > User). */
                    $this->_idField = 'ID::make(),';

                    $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\ID');
                }
                $relationName = $Field->getAttribute('relationName');
                $resourceName = $Field->getRelatedType()->getBaseName(CaseStyle::Slug, Number::Plural);

                $this->_addRelation($relationName, 'BelongsTo', $resourceName);
                $this->_addUse('LaravelJsonApi\\Eloquent\\Fields\\Relations\\BelongsTo');

                continue;
            }
            $field = $this->_prepareRegularField($Field);

            if (Field::isTechnicalField($columnName)) {
                $this->_technicalFields[$nameCamelCase] = $field;

                continue;
            }
            $this->_regularFields[strtolower($nameCamelCase)] = $field;
        }
        $this->_processBackReferences();
        $this->_processAdditionalRelations();
        $this->_processAppendFields();
        $this->_initUses();

        return $this;

    } // _processType()


    /**
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-04-11
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Schema-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach ($this->_jsonApiServers as $server => $status) {
            if ($status === false) {
                continue;
            }
            $indexQueryCode = $this->_Type->getIndexQuery($server);
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $fileContents = parent::replacePlaceholder('index-query', $indexQueryCode ?? '$Query', $baseFileContents);
            $fileContents = parent::replacePlaceholder('namespace-addition', $server.'\\'.$this->_typeNamePlural, $fileContents);
            /*
            **  Schema-Klasse schreiben. */
            $this->_filePath = 'JsonApi/'.$server.'/'.$this->_typeNamePlural;

            parent::_writeFileContents($this->_Package, $this->_typeName.'Schema.php', $fileContents);

            if ($this->_PackageType === PackageType::Package) {
                new DerivedSchemaGenerator($this->_Type);
            }
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SchemaGenerator extends JsonApiFileGenerator {}
