<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\PolicyGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\RequestGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi\SchemaGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     3.3.0 / 2025-04-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class JsonApiFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_jsonApiNameSpace
     */
    protected $_jsonApiNameSpace;


    /**
     * @var     array $_jsonApiServers
     */
    protected $_jsonApiServers;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     3.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        $this->_stubPath = CodeGenerator::getStubPath('jsonapi');

        parent::__construct($Type);

    } // __construct()


    /**
     *
     * @return 	    $this
     *
     * @version     1.2.0 / 2025-04-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_jsonApiNameSpace = config('jsonapi.namespace', 'JsonApi');
        $this->_jsonApiServers = CodeGenerator::getJsonApiServers();

        return $this;

    } // _init()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @return      void
     *
     * @version     4.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(Type $Type): void
    {
        new SchemaGenerator($Type);
        new RequestGenerator($Type);
        new PolicyGenerator($Type);

    } // process()


} // class JsonApiFileGenerator extends BaseFileGenerator {}
