<?php
/**
 * CodeGenerator Configuration
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

return [

    /*
    |--------------------------------------------------------------------------
    |
    |--------------------------------------------------------------------------
    |
    |
    |
    */
    'column' => [
        '*' => [
            'cast' => null,             // Läuft aktuell automatisch über den Feldtypen
            'filter' => false,
            // NULL, um die Möglichkeit zu haben bei implizit TRUE gesetzten Feldern (z.B. "uuid") auch FALSE zu aktivieren
            'guarded' => null,
            'indexQuery' => false,
            'jsonType' => null,
            'readOnly' => true,
            'rules' => null,
            'ruleType' => null,
            'sortable' => false,
        ],
        'active' => [
            'filter' => true,           // Könnte mit "filter" tatsächlich automatisch funktionieren > Feld ist Boolean, also mögliche Werte begrenzt auf 0 (false) und 1 (true)
            'filter' => [
                'method' => 'where',
                'operator' => '=',
                'value' => 1
            ],
            'sortable' => true,
        ],
        'email' => [
            'rules' => [
                'nullable',
                'email',
                'max:255',
            ],
            'ruleType' => 'email',
            'sortable' => true,
        ],
        'tenant_id' => [
            'filter' => true,
        ],
        'uuid' => [
            'guarded' => true,
        ],
    ],
    'package' => [
        /*
            provideOnlyNeccessaryPrefixes   Präfixe auslassen, wo möglich (z.B. Routen-Relationen > muss dann auch in Schema, Policy... berücksichtigt werden)
        */
        'authors' => [
            'Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>',
        ],
        'baseDir' => 'src',
        'basePath' => null,
        'copyright' => 'bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>',
        'devStart' => date('Y'),
        'isProject' => false,
        'name' => null,
        'namespace' => null,
        'packageName' => null,
        'prefix' => null,
        'usePrefix' => false,       // FALSE = nie, TRUE = immer[, NULL = wie in den Generatoren definiert ?]
        'vendorName' => null,
        'version' => 1.0,
    ],
    'packageConfigVersion' => 1.2,
    'routing' => [
        'mainServer' => null,
        'subServers' => 'readOnly',

        'activeServers' => null,
        'inactiveServers' => 'readOnly',
    ],
    // ???
    'typeColumn' => [
        'users' => [
            'columns' => [
                'email' => [
                    'ruleType' => 'email',
                    'sortable' => true,
                ],
                'name' => [
                    'sortable' => true,
                ],
                'password' => [
                    'cast' => 'hashed',
                    'hidden' => true,
                ],
                'remember_token' => [
                    'guarded' => true,
                    'hidden' => true,
                ],
            ],
        ]
    ]

];
