<?php
/**
 * JasonApi Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\JsonApi;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Generators\CodeGenerator;


/**
 * JasonApi Code Generator Class
 *
 * @version     1.1.0 / 2025-04-16
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DerivedSchemaGenerator extends SchemaGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClass
     */
    protected $_baseClass = 'PackageSchema';


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias = 'PackageSchema';


    /**
     * @var     GeneratorMode $_GeneratorMode
     */
    protected $_GeneratorMode = GeneratorMode::Derived;


    /**
     * @var     string $_originalPackageNamespace
     */
    protected $_originalPackageNamespace;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::JsonApiDerivedSchema->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_resetUses();

        $this->_baseClass = $this->_typeName.'Schema';
        $this->_originalPackageNamespace = $this->_Package->getNamespace();
        /*
        **  Originales Package durch das Projekt-Package ersetzen. */
        $this->_Package = CodeGenerator::getProjectPackage();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $modelNamespace = $this->_packageNamespace.'\\Models';

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_namespace = $this->_packageNamespace.'\\'.$this->_jsonApiNameSpace;

        $this->_addUse($modelNamespace.'\\'.$this->_typeName);

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $baseFileContents = $this->_getPreparedFileContents();
        /*
        **  Schema-Klassen für jeden konfigurierten Server zusammenstellen und speichern. */
        foreach ($this->_jsonApiServers as $server => $status) {
            if ($status === false) {
                continue;
            }
            $baseClassUse = $this->_originalPackageNamespace.'\\'.$this->_jsonApiNameSpace.'\\'.$server.'\\'.$this->_typeNamePlural.'\\'.$this->_baseClass.' as '.$this->_baseClassAlias;

            $this->_addUse($baseClassUse);

            $indexQueryCode = $this->_Type->getIndexQuery($server);
            /*
            **  Server-Spezifische Ersetzungen vornehmen. */
            $baseFileContents = $this->_getPreparedFileContents();

            $fileContents = parent::replacePlaceholder('index-query', $indexQueryCode ?? '$Query', $baseFileContents);
            $fileContents = parent::replacePlaceholder('namespace-addition', $server.'\\'.$this->_typeNamePlural, $fileContents);
            /*
            **  Schema-Klasse schreiben. */
            $this->_filePath = 'JsonApi/'.$server.'/'.$this->_typeNamePlural;

            parent::_writeFileContents($this->_Package, $this->_typeName.'Schema.php', $fileContents);

            $this->_removeUse($baseClassUse);
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class DerivedSchemaGenerator extends SchemaGenerator {}
