<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Elements\Field;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     1.1.0 / 2025-05-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FormRequestUpdateGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * Diese Variable wird in dieser Klasse erst zur Laufzeit gesetzt.
     *
     * @var     string $_filePath
     */
    protected $_filePath;


    /**
     * @var     integer $_maxFieldNameLength
     */
    protected $_maxFieldNameLength = 0;


    /**
     * @var     array $_rules
     */
    protected $_rules = [];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelFormRequestUpdate->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    string
     *
     * @version     1.1.0 / 2025-05-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/form-request.update.stub');
        /*
        **  Platzhalter-Ersetzungen vornehmen. */
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('rules', $this->_prepareRuleReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('traits', $this->_prepareTraitReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name-plural', $this->_typeNamePlural, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-05-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_namespace = $packageNamespace.'\\Http\\Requests';
        $this->_typeHint = $this->_typeName;

        $this->_addTrait('BplanBase\\Globals\\Traits\\FormRequestKeyPrefix');
        $this->_addUse('Illuminate\\Foundation\\Http\\FormRequest');

        return $this;

    } // _init()


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareFieldRules(Field $Field, string $fieldName)
    {
        $rules = $Field->getAttribute('rules');
        $ruleType = $Field->getAttribute('ruleType');
        $type = $Field->getAttribute('type');

        if ($rules !== null) {
            $this->_rules[$fieldName] = $rules;

            return $this;
        }
        $fieldRules = [];

        if ($Field->getAttribute('nullable') === true) {
            $fieldRules['nullable'] = 'nullable';

        } else {
            /*
            **  Bei einem Update ist davon auszugehen, dass das Feld initial mit einem validen
            **  Wert bestückt wurde. Damit auch partielle Updates möglich sind (Felder nur
            **  teilweise enthalten) wird "sometimes" eingesetzt. So wird es valdiert, wenn
            **  das Feld vorhanden ist, löst aber keinen Fehler aus, wenn es fehlt. */
            $fieldRules['sometimes'] = 'sometimes';
            $fieldRules['nullable'] = 'required';
        }
        if ($ruleType !== null) {
            $fieldRules['type'] = $ruleType;

            if ($Field->getAttribute('length') !== null) {
                $fieldRules[] = 'max:'.$Field->getAttribute('length');
            }
            // @todo    Das ist hier nicht sauber. E-Mail-Adressen sind nicht immer automatisch unique.
            if ($ruleType === 'email') {
                $fieldRules['unique'] = 'Rule::unique(\''.$this->_tableName.'\', \''.$fieldName.'\')->ignore($this->_resolveRecordId())';

                $this->_addUse('Illuminate\\Validation\\Rule');
            }
            $this->_rules[$fieldName] = $fieldRules;

            return $this;
        }
        switch ($Field->getAttribute('abstractType')) {
            case 'bool':
                $fieldRules['type'] = 'boolean';
                break;

            case 'datetime':
                $fieldRules['type'] = 'date';
                break;

            case 'integer':
                $fieldRules['type'] = 'integer';
                break;

            case 'string':
                if ($type === 'json') {
                    /*
                    **  Json-Felder müssen mit einem leeren Rule-Array angelegt werden. */
                    $fieldRules = [];

                } else {
                    $fieldRules['type'] = 'string';
                }
                if ($Field->getAttribute('length') !== null) {
                    $fieldRules[] = 'max:'.$Field->getAttribute('length');
                }
                break;

            default:
        }
        if (isset($fieldRules['type']) && $fieldRules['type'] === 'email') {
            // @todo    Das ist hier nicht sauber. E-Mail-Adressen sind nicht immer automatisch unique.
            $fieldRules['unique'] = 'Rule::unique(\''.$this->_tableName.'\', \''.$fieldName.'\')->ignore($this->_resolveRecordId())';
        }
        $this->_rules[$fieldName] = $fieldRules;

        return $this;

    } // _prepareFieldRules()


    /**
     * Bereitet den Ersetzungs-String für den fields-Platzhalter auf
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _prepareRuleReplacement(): string
    {
        $padding = str_repeat(' ', 12);

        ksort($this->_rules);
        /*
        **  Ersetzungs-String für die Felddefinitionen zusammenstellen. */
        $replacement = '';

        if (!empty($this->_rules)) {
            foreach ($this->_rules as $field => $rules) {
                if (is_array($rules)) {
                    $replacement .= "\n".$padding
                        .str_pad("'".$field."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                        .' => [';

                    $separator = '';

                    foreach ($rules as $rule) {
                        if (strpos($rule, 'Rule::') !== false) {
                            $quotedRule = $rule;

                        } else {
                            $quotedRule = "'".$rule."'";
                        }
                        $replacement .= $separator.$quotedRule;
                        $separator = ', ';
                    }
                    $replacement .= '],';

                } else {
                    $replacement .= "\n".$padding
                        .str_pad("'".$field."'", $this->_maxFieldNameLength + 2, ' ', STR_PAD_RIGHT)
                        .' => '.$rules.',';
                }
            }
            $replacement .= "\n";
        }
        return $replacement;

    } // _prepareRuleReplacement()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_processFields();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     * Verarbeitet die Fields zum aktuellen Type
     *
     * @return      $this
     *
     * @version     1.0.0 / 2025-05-20
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _processFields(): self
    {
        /*
        **  Technische/automatische Felder, die übersprungen werden sollen. */
        $skipColumns = [
            'created_at' => true,
            'deleted_at' => true,
            'updated_at' => true,
            'uuid' => true,
        ];
        /*
        **  Fields abarbeiten. */
        foreach ($this->_Fields as $Field) {
            if ($Field->getAttribute('autoIncrement') === true) {
                continue;
            }
            if ($Field->getAttribute('guarded') === true) {
                continue;
            }
            $columnName = $Field->getAttribute('columnName');

            if (isset($skipColumns[$columnName])) {
                continue;
            }
            $this->_prepareFieldRules($Field, $columnName);

            $this->_maxFieldNameLength = max($this->_maxFieldNameLength, strlen($columnName));
        }
        return $this;

    } // _processFields()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-05-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  FormRequest-Klasse schreiben. */
        $this->_filePath = 'Http/Requests/'.$this->_typeNamePlural;

        parent::_writeFileContents($this->_Package, 'UpdateRequest.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class FormRequestUpdateGenerator extends LaravelFileGenerator {}
