<?php
/**
 * Laravel Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ActionCreateGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ActionDeleteGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ActionUpdateGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ControllerGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\FormRequestStoreGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\FormRequestUpdateGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ModelGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ObserverGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\PolicyGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\RepositoryGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel\ServiceGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     1.7.0 / 2025-05-31
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class LaravelFileGenerator extends BaseFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     4.0.0 / 2025-03-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        $this->_stubPath = CodeGenerator::getStubPath('laravel');

        parent::__construct($Type);

    } // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @return      void
     *
     * @version     4.2.0 / 2025-05-31
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function process(Type $Type): void
    {
        new ModelGenerator($Type);
        new ActionCreateGenerator($Type);
        new ActionDeleteGenerator($Type);
        new ActionUpdateGenerator($Type);
        new FormRequestStoreGenerator($Type);
        new FormRequestUpdateGenerator($Type);
        new ControllerGenerator($Type);
        new ObserverGenerator($Type);
        new PolicyGenerator($Type);
        new RepositoryGenerator($Type);
        new ServiceGenerator($Type);

    } // process()


} // class LaravelFileGenerator extends BaseFileGenerator {}
