<?php
/**
 * Livewire Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Livewire;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LivewireFileGenerator;
use BplanBase\CodeGenerator\Helpers\StringHelper;


/**
 * Livewire Code Generator Class
 *
 * @version     1.2.1 / 2025-05-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ModalAddGenerator extends LivewireFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * @var     string $_packageNamespace
     */
    private $_packageNamespace;


    /**
     * @var     string $_view
     */
    private $_view;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LivewireModalAdd->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.1 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_filePath = 'Livewire/'.$this->_typeNamePlural.'/Modals';
        $this->_namespace = $this->_packageNamespace.'\\Livewire\\'.$this->_typeNamePlural.'\\Modals';

        $type = StringHelper::reformat($this->_typeNamePlural, CaseStyle::Slug, Number::Plural);

        if ($this->_Package->isForProject()) {
            $this->_view = 'livewire.'.$type.'.modals.add';
        } else {
            $this->_view = $this->_Package->getPackageName().'::livewire.'.$type.'.modals.add';
        }
        return $this;

    } // _init()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/modal.add.stub');

        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('view', $this->_view, $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse($this->_packageNamespace.'\\Models\\'.$this->_typeName);
        $this->_addUse($this->_packageNamespace.'\\Services\\'.$this->_typeName.'Service');
        $this->_addUse('Illuminate\\Support\\Facades\\Log');
        $this->_addUse('Livewire\\Component');

        parent::_prepareUses();

        return $this;

    } // _initUses()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Repository-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, 'Add.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ModalAddGenerator extends LivewireFileGenerator {}
