<?php
/**
 * WinMerge Code Generator Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\WinMerge;


use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\WinMergeGenerator;


/**
 * WinMerge Code Generator Class
 *
 * @version     1.3.0 / 2025-05-04
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class CompareFileGenerator extends WinMergeGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir = 'etc';


    /**
     * @var     boolean $_buildOnlyMode
     */
    protected $_buildOnlyMode = false;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::WinMerge->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-03-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        foreach ($this->_types as $Type) {
            $Package = $Type->getPackage();

            $packageName = $Package->getName();

            $this->_packages[$packageName] = $Package;
        }
        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-02-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $baseFileContents = file_get_contents($this->_stubPath.'/compare.stub');

        $ProjectPackage = CodeGenerator::getProjectPackage();

        $buildBasePath = $ProjectPackage->getBasePath().'/storage/app/build/CodeGenerator';
        /*
        **  Pfade abarbeiten. */
        foreach ($this->_packages as $packageName => $Package) {
            $baseDir = $Package->getBaseDir();

            $paths = [
                $baseDir => $baseDir,
                'routes' => 'routes',
            ];
            foreach ($paths as $filename => $baseDir) {
                // $baseDir = $Package->getBaseDir();

                if ($Package->isForProject()) {
                    $buildPath = '..\\storage\\app\\build\\CodeGenerator\\'.$baseDir.'\\';
                    $codePath = '..\\'.$baseDir.'\\';

                } else {
                    $basePath = $Package->getBasePath();
                    $buildPath = realpath($buildBasePath.'/vendor/'.$Package->getName().'/'.$baseDir);
                    $codePath = realpath($basePath.'/'.$baseDir);
                }
                $fileContents = parent::replacePlaceholder('left-path', $codePath, $baseFileContents);
                $fileContents = parent::replacePlaceholder('right-path', $buildPath, $fileContents);
                /*
                **  Compare-Datei schreiben. */
                parent::_writeFileContents($Package, $filename.'.WinMerge', $fileContents);
            }
        }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class CompareFileGenerator extends WinMergeGenerator {}
