<?php
/**
 * Laravel Code Generator Class
 *
 * @version     3.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Laravel;


use BplanBase\CodeGenerator\Elements\Type;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Enums\GeneratorMode;
use BplanBase\CodeGenerator\Enums\PackageType;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LaravelFileGenerator;


/**
 * Laravel Code Generator Class
 *
 * @version     4.4.0 / 2025-11-19
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class RepositoryGenerator extends LaravelFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Der Aliasname der Elternklasse (nur abgeleitete Klassen).
     *
     * @var     string $_baseClassAlias
     */
    protected $_baseClassAlias;


    /**
     * Der Name der obersten Verzeichnisebene nach dem BasePath (z.B. "app").
     *
     * @var     string $_baseDir
     */
    protected $_baseDir;


    /**
     * Der relative Pfad zum Zielverzeichnis, ausgehend vom Wurzelverzeichnis des Projekts
     *
     * @var     string $_filePath
     */
    protected $_filePath = 'Repositories';


    /**
     * @var     string $_modelNamespace
     */
    protected $_modelNamespace;


    /**
     * @var     string $_packageNamespace
     */
    protected $_packageNamespace;


    /**
     * @var     array $_replacements
     */
    protected array $_replacements = [
        'active-filter' => '
        if ($withInactive === false) {
            $Query->active();
        }',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LaravelRepository->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Type $Type
     *
     * @version     1.0.0 / 2025-05-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(Type $Type)
    {
        if ($Type->hasExclude(Generator::LaravelRepository)) {
            $this->_exclude = true;
        }
        parent::__construct($Type);

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.9.0 / 2025-06-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $fileContents = file_get_contents($this->_stubPath.'/repository.stub');

            if ($this->_Type->hasField('active')) {
                $fileContents = parent::replacePlaceholder('get-all-method', file_get_contents($this->_stubPath.'/snippets/repository/method.GetAll.active.stub'), $fileContents);

            } else {
                $fileContents = parent::replacePlaceholder('get-all-method', file_get_contents($this->_stubPath.'/snippets/repository/method.GetAll.stub'), $fileContents);
            }
            if ($this->_Type->hasField('uuid')) {
                $fileContents = parent::replacePlaceholder('get-by-uuid-method', file_get_contents($this->_stubPath.'/snippets/repository/method.GetByUuid.stub'), $fileContents);
            } else {
                $fileContents = parent::replacePlaceholder('get-by-uuid-method', '', $fileContents);
            }
        } else {
            $fileContents = file_get_contents($this->_stubPath.'/derived.repository.stub');

            $fileContents = parent::replacePlaceholder('base-class', $this->_baseClassAlias, $fileContents);
        }
        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('type-hint', $this->_typeHint, $fileContents);
        $fileContents = parent::replacePlaceholder('type-name', $this->_typeName, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.9.0 / 2025-06-04
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_modelNamespace = $this->_packageNamespace.'\\Models';
        $this->_namespace = $this->_packageNamespace.'\\Repositories';
        $this->_typeHint = $this->_typeName.'|Derived'.$this->_typeName;

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.6.0 / 2025-06-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        if ($this->_GeneratorMode === GeneratorMode::Default) {
            $this->_addUse('BplanBase\\Globals\\Foundation\\Repositories\\BaseRepository');
            $this->_addUse('BplanBase\\Globals\\ValueObjects\\PaginateArgs');
            $this->_addUse('Illuminate\\Database\\Eloquent\\Builder');
            $this->_addUse('Illuminate\\Database\\Eloquent\\Collection');
            $this->_addUse('Illuminate\\Database\\Eloquent\\Model');
            $this->_addUse('Illuminate\\Pagination\\LengthAwarePaginator');

            $this->_addUse($this->_modelNamespace.'\\'.$this->_typeName);
        }
        return parent::_prepareUses();

    } // _initUses()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2024-10-22
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.4.0 / 2025-06-19
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Repository-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, $this->_typeName.'Repository.php', $fileContents);

        // if ($this->_PackageType === PackageType::Package) {
        //     new DerivedRepositoryGenerator($this->_Type);
        // }
        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class RepositoryGenerator extends LaravelFileGenerator {}
