<?php
/**
 * Livewire Code Generator Class
 *
 * @version     3.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Generators
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Generators\CodeGenerator\Livewire;


use BplanBase\CodeGenerator\Enums\CaseStyle;
use BplanBase\CodeGenerator\Enums\Number;
use BplanBase\CodeGenerator\Enums\Generator;
use BplanBase\CodeGenerator\Generators\CodeGenerator\LivewireFileGenerator;
use BplanBase\CodeGenerator\Helpers\StringHelper;


/**
 * Livewire Code Generator Class
 *
 * @version     1.3.0 / 2025-11-19
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class IndexGenerator extends LivewireFileGenerator
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_packageNamespace
     */
    private $_packageNamespace;


    /**
     * @var     string $_view
     */
    private $_view;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_generator
     */
    protected static $_generator = Generator::LivewireIndex->value;


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.1 / 2025-03-25
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _init(): self
    {
        parent::_init();

        $this->_packageNamespace = $this->_Package->getNamespace();

        $this->_baseDir = $this->_Package->getBaseDir();
        $this->_filePath = 'Livewire/'.$this->_typeNamePlural;
        $this->_namespace = $this->_packageNamespace.'\\Livewire\\'.$this->_typeNamePlural;

        $type = StringHelper::reformat($this->_typeNamePlural, CaseStyle::Slug, Number::Plural);

        if ($this->_Package->isForProject()) {
            $this->_view = 'livewire.'.$type.'.index';
        } else {
            $this->_view = $this->_Package->getPackageName().'::livewire.'.$type.'.index';
        }
        $this->_addUse($this->_packageNamespace.'\\Models\\'.$this->_typeName);
        $this->_addUse('Livewire\\Component');

        return $this;

    } // _init()


    /**
     *
     * @return 	    $this
     *
     * @version     1.1.0 / 2025-04-10
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _initUses(): self
    {
        $this->_addUse($this->_packageNamespace.'\\Models\\'.$this->_typeName);
        $this->_addUse('Livewire\\Component');

        parent::_prepareUses();

        return $this;

    } // _initUses()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _getPreparedFileContents(): string
    {
        /*
        **  Stub-File auslesen und Ersetzungen durchführen. */
        $fileContents = file_get_contents($this->_stubPath.'/index.stub');

        $fileContents = parent::replacePlaceholder('namespace', $this->_namespace, $fileContents);
        $fileContents = parent::replacePlaceholder('uses', $this->_prepareUseReplacement(), $fileContents);
        $fileContents = parent::replacePlaceholder('view', $this->_view, $fileContents);

        return $fileContents;

    } // _getPreparedFileContents()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function _process(): self
    {
        // $this->_initUses();

        $this->_writeFile();

        return $this;

    } // _process()


    /**
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2025-03-16
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    private function _writeFile(): self
    {
        $fileContents = $this->_getPreparedFileContents();
        /*
        **  Repository-Klasse schreiben. */
        parent::_writeFileContents($this->_Package, 'Index.php', $fileContents);

        return $this;

    } // _writeFile()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class IndexGenerator extends LivewireFileGenerator {}
