<?php
/**
 * Service Provider Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-base/laravel-code-generator
 * @subpackage  Providers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanBase\CodeGenerator\Providers;


use BplanBase\CodeGenerator\Generators\CodeGenerator;
use BplanBase\CodeGenerator\Loaders\CodeGenerator as CodeGeneratorLoader;
use Illuminate\Console\Events\CommandFinished;
use Illuminate\Console\Events\CommandStarting;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;
use Laravel\Prompts\Output\ConsoleOutput;


/**
 * Service Provider Class
 *
 * @version     1.5.0 / 2025-11-23
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class EventServiceProvider extends ServiceProvider
{


    /* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */

    /**
     * The event listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Register any events for your application.
     *
     * @return      void
     *
     * @version     1.5.0 / 2025-11-23
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function boot()
    {
        Event::listen(function (CommandStarting $command) {
            if ($command->command === 'migrate' || $command->command === 'migrate:fresh' || $command->command === 'migrate:refresh') {
                $Output = new ConsoleOutput();

                $outputString = "\n\n".'    <fg=green>CodeGenerator</> is present';

                if (config('code-generator.active') === true) {
                    if ($command->command === 'migrate' || $command->command === 'migrate:refresh') {
                        $outputString .= ' and activated, but requires migrations to be started with “migrate:fresh” in order to work.';

                        $Output->writeln($outputString."\n");

                    } else {
                        CodeGeneratorLoader::awaitingStart(true);

                        $outputString .= ' and is awaiting to get started'
                            .' - BuildOnlyMode '.(config('code-generator.build-only-mode') == true ? '<info> on </info>' : '<error> off </error>')
                            .' - TestMode '.(config('code-generator.test-mode') == true ? '<info> on </info>' : '<error> off </error>')
                            .' - Routing '.(config('code-generator.skip-routing') == false ? '<info> on </info>' : '<error> off </error>');

                        $Output->writeln($outputString."\n");

                        CodeGenerator::onBeforMigrate();
                    }

                } else {
                    if ($command->command === 'migrate' || $command->command === 'migrate:refresh') {
                        $outputString .= ', but requires migrations to be started with “migrate:fresh” in order to work.';
                    } else {
                        $outputString .= ', but not activated.';
                    }
                    $Output->writeln($outputString."\n");
                }
            }
        });
        if (config('code-generator.active') === true) {
            Event::listen(function (CommandFinished $command) {
                if ($command->command === 'migrate:fresh') {
                    CodeGenerator::generate();
                }
            });
        }
    } // boot()


    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return      bool
     *
     * @version     1.0.0 / 2024-10-06
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function shouldDiscoverEvents()
    {
        return false;

    } // shouldDiscoverEvents()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class EventServiceProvider extends ServiceProvider {}
