<?php
/**
 * Artisan Command Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/filler-service
 * @subpackage  Commands
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\FillerService\Console\Commands;


use BplanBase\Globals\Traits\MakeHelpers;
use Illuminate\Console\GeneratorCommand;
use Illuminate\Support\Str;
use Symfony\Component\Console\Input\InputOption;


/**
 * Artisan Command Class
 *
 * @version     1.0.0 / 2025-05-08
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class MakePreparerCommand extends GeneratorCommand
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    use MakeHelpers;


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $description
     */
    protected $description = 'Creates a new Filler Preparer Class';


    /**
     * @var     string $name
     */
    protected $name = 'make:filler-preparer';


    /**
     * @var     string $type
     */
    protected $type = 'Preparer';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $rootNamespace
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function getDefaultNamespace($rootNamespace): string
    {
        return $rootNamespace.'\\Filler\\Preparers';

    } // getDefaultNamespace()


    /**
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function getOptions(): array
    {
        return array_merge(parent::getOptions(), [
            ['force', 'f', InputOption::VALUE_NONE, 'Overwrites an existing file.'],
        ]);
    } // getOptions()


    /**
     *
     * @param       string $name
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function getPath($name)
    {
        $name = Str::replaceFirst($this->rootNamespace(), '', $name);

        return $this->laravel['path'].'/'.str_replace('\\', '/', $name).'.php';

    } // getPath()


    /**
     * Gibt den Pfad zur Stub-Datei zurück
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function getStub(): string
    {
        return realpath(__DIR__.'/../../../stubs/filler-service/preparer.stub');

    } // getStub()


    /**
     *
     * @param       string $name
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function qualifyClass($name)
    {
        $name = Str::studly($name);

        if (!Str::endsWith($name, 'Preparer')) {
            $name .= 'Preparer';
        }
        return parent::qualifyClass($name);

    } // qualifyClass()


    /**
     * Ersetzt Platzhalter im Stub
     *
     * @param       string $stub
     *
     * @param       string $name
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-05-08
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    protected function replaceClass($stub, $name): string
    {
        $stub = parent::replaceClass($stub, $name);

        $className = class_basename($name);

        $config = config('package-code-generator.package');

        $stub = $this->_replaceAuthorPlaceholder($config['authors'], $stub);
        $stub = $this->_replacePlaceholder('class', $className, $stub);
        $stub = $this->_replacePlaceholder('copyright', $this->_getCopyrightReplacement($config), $stub);
        $stub = $this->_replacePlaceholder('date', date('Y-m-d'), $stub);
        $stub = $this->_replacePlaceholder('doc-package', $config['packageName'], $stub);

        return $stub;

    } // replaceClass()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class MakePreparerCommand extends GeneratorCommand {}