<?php
/**
 * DTO Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/filler-service
 * @subpackage  DTOs
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

declare(strict_types=1);

namespace BplanComponents\FillerService\DTOs;


/**
 * DTO Class
 *
 * @version     1.0.0 / 2025-05-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class PreparedDataDTO
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $iniFileName
     *              The ini file name.
     *
     * @param       string $jsonFile
     *              The full path to the generated JSON data file.
     *
     * @param       array $jsonData
     *              The data written to the JSON data file.
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(
        public string $layoutType,
        public string $iniFileName,
        public string|null $jsonFile = null,
        public array|null $jsonData = null

    ) {} // __construct()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class PreparedDataDTO {}
