<?php
/**
 * Dispatcher Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/filler-service
 * @subpackage  Dispatchers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

declare(strict_types=1);

namespace BplanComponents\FillerService\Dispatchers;


use BplanComponents\FillerService\Contracts\DataPreparerInterface;
use BplanComponents\FillerService\DTOs\PreparedDataDTO;
use InvalidArgumentException;
use RuntimeException;


/**
 * Dispatcher Class
 *
 * @version     1.0.0 / 2025-05-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class DataPreparerDispatcher
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $type
     *
     * @param       array $params
     *
     * @throws      InvalidArgumentException
     *
     * @throws      RuntimeException
     *
     * @return      PreparedDataDTO
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function handle(string $type, array $params): PreparedDataDTO
    {
        $map = config('filler-service.types');

        if ($map === null) {
            throw new RuntimeException('Type configuration missing');
        }
        if (!array_key_exists($type, $map)) {
            throw new InvalidArgumentException('Unsupported type: ['.$type.']');
        }
        $preparerClass = $map[$type];

        if (!class_exists($preparerClass)) {
            throw new RuntimeException('Unknown class '.$preparerClass);
        }
        if (!is_subclass_of($preparerClass, DataPreparerInterface::class)) {
            throw new RuntimeException($preparerClass.' must implement interface [DataPreparerInterface]');
        }
        /**
         * @var     DataPreparerInterface $preparer */
        //$Preparer = app($preparerClass);
        $Preparer = new $preparerClass($type);

        return $Preparer->prepare($params);

    } // handle()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class DataPreparerDispatcher {}