<?php
/**
 * Procedure Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/filler-service
 * @subpackage  Procedures
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

declare(strict_types=1);

namespace BplanComponents\FillerService\Http\Procedures;


use BplanComponents\FillerService\Dispatchers\DataPreparerDispatcher;
use BplanComponents\FillerService\Services\FillerService;
use Sajya\Server\Annotations\Param;
use Sajya\Server\Annotations\Result;
use Sajya\Server\Http\Request;
use Sajya\Server\Procedure;


/**
 * Procedure Class
 *
 * @version     1.0.0 / 2025-05-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FillerProcedure extends Procedure
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * The name of the procedure that is used for referencing.
     *
     * @var     string
     */
    public static string $name = 'filler';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Create the print-file
     *
     * @Param(name="appointmentId", value="required|string")
     *
     * @Result(name="files", value="required|array")
     *
     * @param       Request $Request
     *
     * @return      array
     *
     * @version     1.0.0 / 2025-05-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(Request $Request): array
    {
        $requestParams = $Request->getParams()->toArray();

        $Dto = app(DataPreparerDispatcher::class)->handle($requestParams['type'], $requestParams['data']);

        return [
            'files' => app(FillerService::class)->handle($Dto),
        ];
    } // create()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class FillerProcedure extends Procedure {}
