## ics-file
Package to create iCalendar/ICS files. Send new appointment invitations by email or update or cancel invitations that have already been sent. This is a revision of the [sssurii/laravel-ics](https://github.com/sssurii/laravel-ics) package, that offers more options.

Additional options, compared to the package sssurii/laravel-ics:
- Add multiple events to an ics-file.
- Add one or more attendees per event. Attendees can be required or not required.

### Installation
Install using composer:

	`composer require bplan/ics-file`


### Configuration

There are various configuration options that can be set via the “.env” configuration file.


`ICS_DAYLIGHT_SAVING    bool`

Set `ICS_DAYLIGHT_SAVING` to TRUE if you are sending an invitation from the day light saving region (default _false_). Otherwise leave the value set to FALSE.


`ICS_DAYLIGHT_SAVING_END_MONTH    int`

Set `ICS_DAYLIGHT_SAVING_END_MONTH` to the month number in which day light saving ends in your region (default _10_). For example, in Germany it is 10 for October.


`ICS_DAYLIGHT_SAVING_OFFSET    string`

Set `ICS_DAYLIGHT_SAVING_OFFSET` to the offset in hours for day light saving (default "_1 hours_"). For example, in Germany it is 1 hour.


`ICS_DAYLIGHT_SAVING_START_MONTH    int`

Set `ICS_DAYLIGHT_SAVING_START_MONTH` to the month number in which day light saving starts in your region (default _3_). For example, in Germany it is 3 for March.


### Usage

Set various event details, pass properties as array while initializing class:
```

    use Bplan\ICS\ICS\Event;
    use Bplan\ICS\ICS\ICSFile;

    $eventData = [
        'uid' => uniqid(),
        'description' => 'Event Invitation via email.',
        'dtend' => date('Y-m-d 10:00'),
        'dtstart' => date('Y-m-d 09:00'),
        'location' => 'Max-Reichpietsch-Str. 22, 51147 Köln',
        'sequence' => 0,
        'summary' => 'This is an event invitation sent through email.',
        'url' => 'www.example.com',
    ];

    $Event = new Event($eventData);

    $IcsFile = new ICSFile($eventData);

    $IcsFile->addEvent($Event);

    $IcsFile->toString();

```

Some optional event properties can be set using special methods.
```
    // Set the organizer of the event
    $Event->setOrganizer('Organizer Name', 'organizer@example.com');

    // Add one or multiple attendees to the event
    $Event->addAttendee('Organizer Name', 'organizer@example.com', accepted: true, required: true);
    $Event->addAttendee('Attendee Name', 'attendee@example.com', required: true);
```

If you want to cancel an invitation that has already been sent, use the following method:
```
    // Cancel the event(s)
    $IcsFile->setMethodCancel();
```

**Note:** To cancel an invitation that has already been sent, you must use the same `uid` that was used in the original invitation.


### Publishing

The following command can be used to publish the configuration file:

`php artisan vendor:publish --provider="Bplan\ICS\PackageServiceProvider" --tag=config`

Normally, the configuration should always be made via the ".env" file so that it is not necessary to publish the configuration file.

