<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/ics-file
 * @subpackage  ICS
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\ICS\ICS;


use Exception;


/**
 *
 * @version     1.0.0 / 2024-12-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class ICSFile
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         array $_events
     */
    protected array $_events = [];


    /**
     * @var         array $_headerProperties
     */
    private array $_headerProperties = [
        'BEGIN:VCALENDAR',
        'VERSION:2.0',
        'PRODID:-//bplan/NONSGML ics-file v1.0//{{ lang }}}',
        'CALSCALE:GREGORIAN',
        'METHOD:{{ method }}',
    ];


    /**
     * @var         string $_method
     */
    private string $_method = 'REQUEST';


    /**
     * @var         string $_language
     */
    private string $_language = 'EN';


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       Event $Event
     *
     * @return      $this
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function addEvent(Event $Event): self
    {
        $this->_events[] = $Event;

        return $this;

    } // addEvent()


    /**
     *
     * @return      $this
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setMethodCancel(): self
    {
        $this->_method = 'CANCEL';

        return $this;

    } // setMethodCancel()


    /**
     *
     * @param       string $languageCode
     *
     * @return      $this
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setLanguage(string $languageCode): self
    {
        $this->_language = strtoupper(substr($languageCode, 0, 2));

        return $this;

    } // setLanguage()


    /**
     *
     * @return      string
     *
     * @version     1.0.0 / 2024-12-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function toString(): string
    {
        if (empty($this->_events)) {
            throw new Exception('There has to be at least one event defined');
        }
        $string = str_replace(
            ['{{ lang }}', '{{ method }}'],
            [$this->_language, $this->_method],
            implode("\r\n", $this->_headerProperties)
        );
        foreach ($this->_events as $Event) {
            $string .= "\r\n".$Event->toString();
        }
        $string .= "\r\n".'END:VCALENDAR';

        return $string;

    } // toString()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class ICSFile {}
