## Spryng for Laravel

Spryng package for Laravel.

### Installation

As the package is not in a public repository, the repository must be registered in the first installation step:

`composer config repositories.bplan/laravel-spryng vcs https://git.bplan-solutions.de:3000/bplan/laravel-spryng.git`

The package can then be installed:

`composer require bplan/laravel-spryng`


### Configuration

All configuration settings can be set via the _.env_ file.

`SPRYNG_SMS_API_TOKEN`
The Rest API Key/Token (no default).

`SPRYNG_SMS_ENCODING`
Character encoding of the body. Value can be: `plain`, `unicode` or `auto` (default: "auto")

`SPRYNG_SMS_ORIGINATOR`
The sender of the message. Can be alphanumeric string (max. 11 characters) or phonenumber (max. 14 digits in E.164 format like 31612345678, default "BplanSpryng").

`SPRYNG_SMS_REFERENCE`
A client reference (default "bplan/laravel-spryng").

`SPRYNG_SMS_ROUTE`
Your given route to send the message on. Can be a valid route ID supplied by Spryng or the default business route (default "business").


### Publishing

The following command can be used to publish the configuration file:

`php artisan vendor:publish --provider="Bplan\LaravelSpryng\PackageServiceProvider" --tag=config`


### Usage

You can use the channel in your `via()` method inside the notification:


```php

use Bplan\LaravelSpryng\Notifications\SmsChannel;
use Bplan\LaravelSpryng\Notifications\SmsMessage;
use Illuminate\Notifications\Notification

class VisitorArrived extends Notification
{

    public function toSpryngSms(object $Notifiable): SmsMessage
    {
        $body = 'Your visitor has arrived.';

        return new SmsMessage($body);

    } // toSpryngSms()


    public function via(object $Notifiable): array
    {
        return [
            SmsMessage::class
        ];
    } // via()


} // class VisitorArrived extends Notification {}

```


Add a `routeNotificationForSpryngSms` method to your Notifiable model to return the phone number:

```php

use Bplan\LaravelSpryng\Notifications\SmsChannel;
use Bplan\LaravelSpryng\Notifications\SmsMessage;
use Illuminate\Notifications\Notification;

class VisitorArrived extends Notification
{
    ...

    public function routeNotificationForSpryngSms(): string
    {
        return $this->mobile_phone_number;

    } // routeNotificationForSpryngSms()


} // class VisitorArrived extends Notification {}

```

