<?php
/**
 * Spryng Configuration
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-spryng
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

return [

    /*
    |----------------------------------------------------------------------
    | Encoding
    |----------------------------------------------------------------------
    |
    | Character encoding of the body. Value can be: plain, unicode or auto
    |
    */
    'encoding' => env('SPRYNG_SMS_ENCODING', 'auto'),

    /*
    |----------------------------------------------------------------------
    | Originator (From)
    |----------------------------------------------------------------------
    |
    | The sender of the message. Can be alphanumeric string (max. 11 characters) or
    | phonenumber (max. 14 digits in E.164 format like 31612345678).
    |
    */
    'originator' => env('SPRYNG_SMS_ORIGINATOR', 'BplanSpryng'),

    /*
    |----------------------------------------------------------------------
    | Reference
    |----------------------------------------------------------------------
    |
    | A client reference.
    |
    */
    'reference' => env('SPRYNG_SMS_REFERENCE', 'bplan/laravel-spryng'),

    /*
    |----------------------------------------------------------------------
    | Route
    |----------------------------------------------------------------------
    |
    | Your given route to send the message on. Can be a valid route ID supplied by
    | Spryng or the default business route.
    |
    */
    'route' => env('SPRYNG_SMS_ROUTE', 'business'),

    /*
    |----------------------------------------------------------------------
    | Api-Key/Auth-Token
    |----------------------------------------------------------------------
    |
    | The Rest API Key/Token.
    |
    */
    'token' => env('SPRYNG_SMS_API_TOKEN'),

];
