<?php
/**
 * Spryng SMS Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-spryng
 * @subpackage  SpryngSMS
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

 namespace Bplan\LaravelSpryng\Notifications;


use Illuminate\Http\Client\RequestException;
use Illuminate\Notifications\Notification;


/**
 * Spryng SMS Class
 *
 * @version     1.0.0 / 2024-11-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SmsChannel
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     SmsClient $_Client
     */
    private SmsClient $_Client;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       SmsClient $Client
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(SmsClient $Client)
    {
        $this->_Client = $Client;

    } // __construct(()


    /**
     *
     * @param       object $Notifiable
     *
     * @param       Notification $Notification
     *
     * @throws      RequestException|Exceptions\CouldNotSendSmsNotification
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function send(object $Notifiable, Notification $Notification): void
    {
        $Message = $Notification->toSpryngSms($Notifiable);

        if (is_string($Message)) {
            $Message = new SmsMessage($Message);
        }
        if ($Message->hasRecipients() === false && method_exists($Notifiable, 'routeNotificationForSpryngSms')) {
            $Message->setRecipients($Notifiable->routeNotificationForSpryngSms());
        }
        if (!empty(array_filter($Message->getRecipients()))) {
            $this->_Client->send($Message);
        }
    } // send()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SmsChannel {}
