<?php
/**
 * Spryng SMS Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-spryng
 * @subpackage  SpryngSMS
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelSpryng\Notifications;


use Bplan\LaravelSpryng\Exceptions\CouldNotSendSmsNotification;
use Illuminate\Support\Facades\Log;
use Spryng\SpryngRestApi\Objects\Message;
use Spryng\SpryngRestApi\Spryng;


/**
 * Spryng SMS Class
 *
 * @version     1.1.0 / 2024-11-14
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SmsClient
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     Spryng $_Client
     */
    private Spryng $_Client;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct()
    {
        $this->_Client = new Spryng(config('spryng.token'));

    } // __construct()


    /**
     *
     * @param       SmsMessage $Message
     *
     * @throws      CouldNotSendSmsNotification
     *
     * return       bool
     *
     * @version     1.1.0 / 2024-11-14
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function send(SmsMessage $Message): bool
    {
        $SpryngMessage = app(Message::class);

        $SpryngMessage->setBody($Message->getBody());
        $SpryngMessage->setEncoding($Message->getEncoding() ?? config('spryng.encoding'));
        $SpryngMessage->setOriginator($Message->getOriginator() ?? config('spryng.originator'));
        $SpryngMessage->setRecipients($Message->getRecipients() ?? []);
        $SpryngMessage->setReference($Message->getReference() ?? config('spryng.reference'));
        $SpryngMessage->setRoute($Message->getRoute() ?? config('spryng.route'));

        $Response = $this->_Client->message->create($SpryngMessage);

        if ($Response->wasSuccessful() === false) {
            Log::error($Response->getRawBody());

            throw new CouldNotSendSmsNotification($Response->getRawBody(), $Response->getResponseCode());
        }
        return true;

    } // send()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SmsClient {}
