<?php
/**
 * Spryng SMS Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-spryng
 * @subpackage  SpryngSMS
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelSpryng\Notifications;


/**
 * Spryng SMS Class
 *
 * @version     1.0.0 / 2024-11-07
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class SmsMessage
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var     string $_body
     */
    private $_body;


    /**
     * @var     string $_encoding
     */
    private $_encoding;


    /**
     * @var     string $_originator
     */
    private $_originator;


    /**
     * @var     array $_recipients
     */
    private $_recipients;


    /**
     * @var     string $_reference
     */
    private $_reference;


    /**
     * @var     string $_route
     */
    private $_route;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $body
     *
     * @param       null|string $encoding
     *
     * @param       null|string $originator
     *
     * @param       array|string $recipients
     *
     * @param       null|string $reference
     *
     * @param       null|string $route
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct(string $body, null|string $encoding = null, null|string $originator = null, array|string $recipients = [], null|string $reference = null, null|string $route = null)
    {
        $this->_body = $body;
        $this->_encoding = $encoding;
        $this->_originator = $originator;
        $this->_reference = $reference;
        $this->_route = $route;

        $this->setRecipients($recipients);

    } // __construct()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getBody(): string
    {
        return $this->_body;

    } // getBody()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getEncoding(): null|string
    {
        return $this->_encoding;

    } // getEncoding()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getOriginator(): null|string
    {
        return $this->_originator;

    } // getOriginator()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRecipients(): array
    {
        return $this->_recipients;

    } // getRecipients()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getReference(): null|string
    {
        return $this->_reference;

    } // getReference()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getRoute(): null|string
    {
        return $this->_route;

    } // getRoute()


    /**
     *
     * @return 	    array
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function hasRecipients(): bool
    {
        return !empty($this->_recipients);

    } // hasRecipients()


    /**
     *
     * @param       string $body
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setBody(string $body): self
    {
        $this->_body = $body;

        return $this;

    } // setBody()


    /**
     *
     * @param       string $encoding
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setEncoding(string $encoding): self
    {
        $this->_encoding = $encoding;

        return $this;

    } // setEncoding()


    /**
     *
     * @param       string $originator
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setOriginator(string $originator): self
    {
        $this->_originator = $originator;

        return $this;

    } // setOriginator()


    /**
     *
     * @param       array $recipients
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setRecipients(array|string $recipients): self
    {
        if (is_string($recipients)) {
            $recipients = (array) $recipients;
        }
        $this->_recipients = $recipients;

        return $this;

    } // setRecipients()


    /**
     *
     * @param       string $reference
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setReference(string $reference): self
    {
        $this->_reference = $reference;

        return $this;

    } // setReference()


    /**
     *
     * @param       string $route
     *
     * @return 	    $this
     *
     * @version     1.0.0 / 2024-11-07
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setRoute(string $route): self
    {
        $this->_route = $route;

        return $this;

    } // setRoute()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class SmsMessage {}
