<?php
/**
 * Repository Interface
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-vega-rpc
 * @subpackage  Interfaces
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelVegaRpc\Repositories;


/**
 * Repository Interface
 *
 * @version     1.0.0 / 2024-09-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
interface VegaLicensePlateRepositoryInterface
{


    /**
     *
     * @param       string $licensePlate
     *
     * @return      bool
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function checkPermission(string $licensePlate, array|string & $result): bool;


} // interface VegaLicensePlateRepositoryInterface {}
