## laravel-vega-rpc

A JSON-RPC 2.0 server interface for the "Vega Embedded System for Automatic Number Plate Recognition" to check license plates and access authorization against a data base.

### Installation

As the package is not in a public repository, the repository must be registered in the first installation step:

`composer config repositories.bplan/laravel-vega-rpc vcs https://git.bplan-solutions.de:3000/bplan/laravel-vega-rpc.git`

The package can then be installed:

`composer require bplan/laravel-vega-rpc`

Finally, the migrations must be carried out:

`php artisan migrate`

### Configuration

The package offers the option of implementing your own logic for determining access authorization information. For this purpose, the repository in which the method is implemented can be specified in the .env file:

`BPLAN_VEGA_RPC_REPOSITORY_CLASS = App\Repositories\LicensePlateRepository`

Setting this configuration option **before executing the migration** ensures that the database table “_vega_license_plates_” is not created and that you can use your own database table and logic to check the access authorization.
The specified repository class must implement the “_checkPermission()_” method defined in the interface “_VegaLicensePlateRepositoryInterface_”.


The default route for the RPC endpoint is “_/api/vega_”. The name of the endpoint (“vega”) can be given a prefix via the .env file:

`BPLAN_VEGA_RPC_ROUTE_PREFIX = terminal`

This setting changes the route of the endpoint to “_/api/terminal/vega_”.


To publish the config, run the vendor publish command:

`php artisan vendor:publish --provider="Bplan\LaravelVegaRpc\PackageServiceProvider" --tag=config`