<?php
/**
 * JSON:API Configuration
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-vega-rpc
 * @subpackage  Config
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Repository
    |--------------------------------------------------------------------------
    |
    | Vollqualifizierter Klassenname der Repository-Klasse, die das Matching übernehmen soll.
    |
    | Wenn die Konfigurationseinstellung BPLAN_VEGA_RPC_REPOSITORY_CLASS in der .env-Datei definiert wird,
    | dann muss der zugewiesene Wert eine einfache Zeichenkette sein (also ohne "::class" am Ende, weil PHP-Code
    | in der .env-Datei nicht ausgeführt wird).
    |
    | Das Repository muss das Interface Bplan\LaravelVegaRpc\Repositories\VegaLicensePlateRepositoryInterface,
    | respektive die folgende Methode, implementieren:
    |
    |       public static function checkPermission(string $licensePlate, array|string & $result): bool;
    */
    'repository-class' => env('BPLAN_VEGA_RPC_REPOSITORY_CLASS', null),

    /*
    |--------------------------------------------------------------------------
    | Route Prefix
    |--------------------------------------------------------------------------
    |
    | Die Standardroute für den Endpoint ist "/api/vega". Diese kann noch durch ein Präfix vor dem
    | Namen des Endpoints ("vega") ergänzt werden (z.B. "terminal" ergibt die Route "/api/terminal/vega").
    |
    | Zur Änderung kann in der .env-Datei der Parameter "BPLAN_VEGA_RPC_ROUTE_PREFIX" verwendet werden.
    */
    'route-prefix' => env('BPLAN_VEGA_RPC_ROUTE_PREFIX', null),

];
