<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-vega-rpc
 * @subpackage  Models
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelVegaRpc\Models;


use Illuminate\Database\Eloquent\Model;


/**
 * Model Class
 *
 * @version     1.1.0 / 2024-11-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VegaMatchLog extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         array $casts
     *
     * @version     1.0.0 / 2024-09-28
     */
    protected $casts = [
        'rpc_params' => 'object',
    ];


    /**
     * @var         array $fillable
     *
     * @version     2.0.0 / 2024-11-26
     */
    protected $fillable = [
        'access_granted',
        'class',
        'country',
        'date',
        'imageid',
        'plate',
        'request_id',
        'result_code',
        'result_message',
        'result_status',
        'rpc_params',
        'time',
    ];


    /**
     * @var         array $guarded
     *
     * @version     1.0.0 / 2024-09-28
     */
    protected $guarded = [
        'created_at',
        'updated_at',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VegaMatchLog extends Model {}
