<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-vega-rpc
 * @subpackage  Services
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelVegaRpc\Services;


use Illuminate\Support\Facades\DB;


use Bplan\LaravelVegaRpc\Actions\VegaLicensePlate\Create;
use Bplan\LaravelVegaRpc\Actions\VegaLicensePlate\Delete;
use Bplan\LaravelVegaRpc\Actions\VegaLicensePlate\Update;
use Bplan\LaravelVegaRpc\Models\VegaLicensePlate;


/**
 * Service Class
 *
 * @version     1.0.0 / 2024-09-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VegaLicensePlateService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      VegaLicensePlate
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): VegaLicensePlate
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       string $id
     *
     * @return      VegaLicensePlate
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(string $id): VegaLicensePlate
    {
        $Action = new Delete();

        return $Action->execute($id);

    } // delete()


    /**
     *
     * @param       string $id
     *
     * @param       array $attributes
     *
     * @return      VegaLicensePlate
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(string $id, array $attributes): VegaLicensePlate
    {
        $Action = new Update();

        return $Action->execute($id, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VegaLicensePlateService {}
