<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-vega-rpc
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */


use Bplan\LaravelVegaRpc\Enums\CheckResultCode;
use Bplan\LaravelVegaRpc\Enums\CheckResultStatus;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vega_match_logs');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('vega_match_logs', function (Blueprint $Table) {
            $Table->id();

            $Table->timestamps();

            $Table->boolean('access_granted');
            $Table->string('class', 20)->nullable();
            $Table->string('country', 3)->nullable();
            $Table->date('date');
            $Table->string('imageid', 255)->nullable();
            $Table->string('plate', 11);
            $Table->bigInteger('request_id');
            $Table->json('rpc_params');
            $Table->enum('result_code', array_column(CheckResultCode::cases(), 'value'));
            $Table->string('result_message', 255)->nullable();
            $Table->enum('result_status', array_column(CheckResultStatus::cases(), 'name'));
            $Table->time('time', 6);
            $Table->string('transit_point', 6)->nullable();
        });
    } // up()


};
