<?php
/**
 * Repository Interface
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan/laravel-vega-rpc
 * @subpackage  Interfaces
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace Bplan\LaravelVegaRpc\Repositories;


/**
 * Repository Interface
 *
 * @version     1.1.0 / 2024-11-09
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
interface VegaLicensePlateRepositoryInterface
{


    /**
     *
     * @param       string $licensePlate
     *              Das zu überprüfende Kennzeichen.
     *
     * @param       array $requestParams
     *              Alle Request-Daten.
     *
     * @param       array|string & $result
     *              Falls der Parameter $result übergeben wurde, wird er mit einem Text gefüllt,
     *              der Details zum Ergebnis beinhaltet.
     *
     * @return      bool
     *
     * @version     2.0.0 / 2024-11-09
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function checkPermission(string $licensePlate, array $requestParams, array|string & $result = null): bool;


} // interface VegaLicensePlateRepositoryInterface {}
