<?php
/**
 * Migration Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/laravel-vega-rpc
 * @subpackage  Migrations
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */


use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;


/**
 * Migration Class
 *
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
return new class extends Migration
{


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('vega_license_plates');

    } // down()


    /**
     * Run the migrations.
     */
    public function up(): void
    {
        /*
        **  Die Tabelle wird nur angelegt, wenn in der Konfiguration kein alternatives Repository definiert oder
        **  die Applikation nicht im Produktiv-Modus ist. Dadurch steht sie auf einem Entwicklungsystem immer
        **  zur Verfügung. */
        if (config('vega-rpc.repository-class') === null || config('app.env') !== 'production') {
            Schema::create('vega_license_plates', function (Blueprint $Table) {
                $Table->id();
                $Table->boolean('active')->default(1);

                $Table->timestamps();

                $Table->string('license_plate', 11)->nullable();
                $Table->boolean('passage_permitted')->default(1);

                $Table->unique('license_plate', 'vega_match_UK_license_plate');
            });
        }
    } // up()


};
