<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/laravel-vega-rpc
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

use Illuminate\Support\Facades\Route;

use BplanComponents\LaravelVegaRpc\Http\Procedures\MatchProcedure;


$config = config('vega-rpc');

$prefix = 'api';

if ($config['route-prefix'] !== null) {
    $prefix .= '/'.$config['route-prefix'];
}

Route::middleware('api')
    ->prefix($prefix)
    ->group(function () {
        Route::rpc('/vega', [MatchProcedure::class], '_')->name('vega.rpc.endpoint');
    }
);
