<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/laravel-vega-rpc
 * @subpackage  Models
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\LaravelVegaRpc\Models;


use Illuminate\Database\Eloquent\Model;


/**
 * Model Class
 *
 * @version     1.2.0 / 2025-01-18
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VegaMatchLog extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         array $casts
     *
     * @version     1.0.0 / 2024-09-28
     */
    protected $casts = [
        'rpc_params' => 'object',
    ];


    /**
     * @var         array $fillable
     *
     * @version     3.0.0 / 2025-01-18
     */
    protected $fillable = [
        'access_granted',
        'class',
        'country',
        'date',
        'imageid',
        'plate',
        'request_id',
        'result_code',
        'result_message',
        'result_status',
        'rpc_params',
        'time',
        'transit_point',
    ];


    /**
     * @var         array $guarded
     *
     * @version     1.0.0 / 2024-09-28
     */
    protected $guarded = [
        'created_at',
        'updated_at',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VegaMatchLog extends Model {}
