<?php
/**
 * Service Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/laravel-vega-rpc
 * @subpackage  Services
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\LaravelVegaRpc\Services;


use BplanComponents\LaravelVegaRpc\Actions\VegaLicensePlate\Create;
use BplanComponents\LaravelVegaRpc\Actions\VegaLicensePlate\Delete;
use BplanComponents\LaravelVegaRpc\Actions\VegaLicensePlate\Update;
use BplanComponents\LaravelVegaRpc\Models\VegaLicensePlate;
use Illuminate\Support\Facades\DB;


/**
 * Service Class
 *
 * @version     1.0.0 / 2024-09-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VegaLicensePlateService
{

/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       array $attributes
     *
     * @return      VegaLicensePlate
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function create(array $attributes): VegaLicensePlate
    {
        $Action = new Create();

        return $Action->execute($attributes);

    } // create()


    /**
     *
     * @param       string $id
     *
     * @return      VegaLicensePlate
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function delete(string $id): VegaLicensePlate
    {
        $Action = new Delete();

        return $Action->execute($id);

    } // delete()


    /**
     *
     * @param       string $id
     *
     * @param       array $attributes
     *
     * @return      VegaLicensePlate
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function update(string $id, array $attributes): VegaLicensePlate
    {
        $Action = new Update();

        return $Action->execute($id, $attributes);

    } // update()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class VegaLicensePlateService {}
