# Laravel Vega RPC Interface

A JSON-RPC 2.0 server interface for the "Vega Embedded System for Automatic Number Plate Recognition" to check license plates and access authorization against a data base.

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:

```bash
composer config repositories.bplan-base/composer-packages composer https://satis.bplan.solutions
```

The package can then be installed:

```bash
composer require bplan-components/laravel-vega-rpc
```

Finally, the migrations must be carried out:

```bash
php artisan migrate
```

## Configuration

The package offers the option of implementing your own logic for determining access authorization information. For this purpose, the repository in which the method is implemented can be specified in the `.env` file:

```toml
BPLAN_VEGA_RPC_REPOSITORY_CLASS = App\Repositories\LicensePlateRepository
```

Setting this configuration option **before executing the migration** ensures that the database table `vega_license_plates` is not created and that you can use your own database table and logic to check the access authorization.
The specified repository class must implement the `checkPermission()` method defined in the interface `VegaLicensePlateRepositoryInterface`.


The default route for the RPC endpoint is `/api/vega`. The name of the endpoint (“vega”) can be given a prefix via the `.env` file:

```toml
BPLAN_VEGA_RPC_ROUTE_PREFIX = terminal
```

This setting changes the route of the endpoint to `/api/terminal/vega`.

Defines the name of the query parameter in which the identifier for the transit point is transferred:

```toml
BPLAN_VEGA_RPC_TRANSIT_POINT_QUERY_PARAMETER = entry-point
```

The default name for the parameter is `transit-point`. The identifier is saved in the database in the `vega_match_logs.transit_point` field (maxlength 6 characters).


To publish the config, run the vendor publish command:

```bash
php artisan vendor:publish --provider="BplanComponents\LaravelVegaRpc\PackageServiceProvider" --tag=config
```

## Dependencies
* "php": "\*",,
* "sajya/server": "^7.0"
