<?php
/**
 * Model Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/laravel-vega-rpc
 * @subpackage  Models
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\LaravelVegaRpc\Models;


use BplanComponents\LaravelVegaRpc\Repositories\VegaLicensePlateRepository;
use ErrorException;
use Illuminate\Database\Eloquent\Model;


/**
 * Model Class
 *
 * @version     1.0.0 / 2024-09-28
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class VegaLicensePlate extends Model
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         string REPOSITORY_CLASS
     */
    const REPOSITORY_CLASS = VegaLicensePlateRepository::class;


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * @var         array $fillable
     *
     * @version     1.0.0 / 2024-09-28
     */
    protected $fillable = [
        'active',
        'license_plate',
        'passage_permitted',
    ];


    /**
     * @var         array $guarded
     *
     * @version     1.0.0 / 2024-09-28
     */
    protected $guarded = [
        'created_at',
        'updated_at',
    ];


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Ermittelt die Repository-Klasse, die die Methode für das Matching der Kennzeichen implementiert
     *
     * @throws      ErrorException Wenn die Repository-Klasse nicht existiert oder die erforderliche
     *              Methode nicht implementiert,
     *
     * @return      string
     *
     * @version     1.0.0 / 2024-09-28
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function determineRepositoryClass(): string
    {
        if (($repositoryClass = config('vega-rpc.repository-class')) === null) {
            $repositoryClass = self::REPOSITORY_CLASS;
        }
        if (!class_exists($repositoryClass)) {
            throw new ErrorException(__('vega-rpc::vega-rpc.error.repository-class-missing', [
                'repository-class' => $repositoryClass,
            ]));
        }
        if (!method_exists($repositoryClass, 'checkPermission')) {
            throw new ErrorException(__('vega-rpc::vega-rpc.error.check-method-missing', [
                'repository-class' => $repositoryClass,
                'method-name' => 'checkPermission',
            ]));
        }
        return $repositoryClass;

    } // determineRepositoryClass()


} // class VegaLicensePlate extends Model {}
