# Web-IO Connect

Send requests to a Web-IO relais.

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:

`composer config repositories.bplan/composer-packages composer https://satis.bplan.solutions`

The package can then be installed:

`composer require bplan-components/web-io-connect`

## Configuration

A password is required if digest authentication is activated. In addition, information is required as to whether the password is the administrator password or that of the simple user.
The settings can be defined in the .env file. The following options are available for this purpose:

```.env

WEB\_IO\_CONNECT\_AUTH\_PASSWORD = "the password"
WEB\_IO\_CONNECT\_AUTH\_USERTYPE = admin

```
Specifying the user type is optional. If the administrator password is to be used, then “admin” must be specified here. If this is not specified or a value other than “admin” is specified, it is assumed that the specified password is that of the normal user.


## Usage

```php

use BplanComponents\WebIoConnect\Connectors\WebIoConnector;
use BplanComponents\WebIoConnect\Enums\State;
use BplanComponents\WebIoConnect\Enums\DeviceType;

$Connector = new WebIoConnector(DeviceType::WebIo57838, 'http://example.com:8080');

$Connector->sendOutputState(2, State::On);

```
The relay types 57732, 57832 and 57838 are currently supported.

## Dependencies
* "php": "\*"
