<?php
/**
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connect
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <http://www.bplan-solutions.de/>
 * /Δ\
 */

use BplanComponents\WebIoConnect\Connectors\WebIoConnector;
use BplanComponents\WebIoConnect\Http\Controllers\FakerController;
use BplanComponents\WebIoConnect\Fakers\WebIoFaker;


 Route::prefix('api')
     ->group(function () {

        $routerBase = WebIoConnector::getFakerRouteBase();

        Route::get('/'.$routerBase.'/rest/json/{deviceType}',                                 [FakerController::class, 'getProcessImage']);

        Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/counter',                 [FakerController::class, 'getCounters']);
        Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/counter/{counter}',       [FakerController::class, 'getCounter']);
        Route::post('/'.$routerBase.'/rest/json/{deviceType}/iostate/counterclear/{counter}', [FakerController::class, 'clearCounter']);

        Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/input',                   [FakerController::class, 'getInputs']);
        Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/input/{input}',           [FakerController::class, 'getInput']);

        Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/output',                  [FakerController::class, 'getOutputs']);
        Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/output/{output}',         [FakerController::class, 'getOutput']);
        Route::post('/'.$routerBase.'/rest/json/{deviceType}/iostate/output/{output}',        [FakerController::class, 'setOutput']);

        if (WebIoFaker::isDevMode() === true) {
            Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/counterclear/{counter}',      [FakerController::class, 'clearCounter']);
            Route::get('/'.$routerBase.'/rest/json/{deviceType}/iostate/output/{output}/set/{state}', [FakerController::class, 'setOutput']);
        }
     }
 );
