<?php
/**
 * Faker Controller Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connect
 * @subpackage  Controllers
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\WebIoConnect\Http\Controllers;


use BplanComponents\WebIoConnect\Enums\DeviceType;
use BplanComponents\WebIoConnect\Fakers\WebIoFaker;
use BplanComponents\WebIoConnect\Helpers\RequestHelper;


/**
 * Faker Controller Class
 *
 * @version     1.0.0 / 2025-04-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class FakerController extends Controller
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @param       string $deviceType
     *
     * @param       int $counter
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function clearCounter(string $deviceType, int $counter)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->clearCounter($counter);

    } // clearCounter()


    /**
     *
     * @param       string $deviceType
     *
     * @param       int $counter
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getCounter(string $deviceType, int $counter)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getCounter($counter);

    } // getCounter()


    /**
     *
     * @param       string $deviceType
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getCounters(string $deviceType)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getCounters();

    } // getCounters()


    /**
     *
     * @param       string $deviceType
     *
     * @param       int $input
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getInput(string $deviceType, int $input)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getInput($input);

    } // getInput()


    /**
     *
     * @param       string $deviceType
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getInputs(string $deviceType)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getInputs();

    } // getInputs()


    /**
     *
     * @param       string $deviceType
     *
     * @param       int $output
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getOutput(string $deviceType, int $output)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getOutput($output);

    } // getOutput()


    /**
     *
     * @param       string $deviceType
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getOutputs(string $deviceType)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getOutputs();

    } // getOutputs()


    /**
     *
     * @param       string $deviceType
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getProcessImage(string $deviceType)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        return $Faker->getProcessImage();

    } // getProcessImage()


    /**
     *
     * @param       string $deviceType
     *
     * @param       int $output
     *
     * @param       null|string $state
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function setOutput(string $deviceType, int $output, null|string $state = null)
    {
        $Faker = new WebIoFaker(DeviceType::getByValue($deviceType));

        $Request = request();

        if ($Request->isMethod('post')) {
            $content = $Request->getContent();

            $params = RequestHelper::parseRawBody($content);

            if (!isset($params['Set'])) {
                return response()->json(['message' => 'Bad Request'], 400);
            }
            $state = $params['Set'];
        }
        return $Faker->setOutput($output, $state);

    } // setOutput()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class FakerController extends Controller {}
