# Web-IO Connect

Send requests to a Web-IO relais.

## Installation

As the package is not in a public repository, the repository must be registered in the first installation step. To avoid having to register a separate repository for each private package, selected packages are made available via a central repository:

`composer config repositories.bplan/composer-packages composer https://satis.bplan.solutions`

The package can then be installed:

`composer require bplan-components/web-io-connect`

## Configuration

All required settings can be made via the _.env_ configuration file.

```toml
WEB_IO_CONNECT_AUTH_PASSWORD = "the password"
```
Only required if digest authentication is used. To avoid problems with any special characters, the password should be placed in quotation marks.

```toml
WEB_IO_CONNECT_AUTH_USERTYPE = admin
```
Specifying the user type is optional. If the administrator password is to be used, then “_admin_” must be specified here. If this is not used or a value other than “_admin_” is specified, then it is assumed that the specified password is that of the normal user.

```toml
WEB_IO_CONNECT_FORCE_REAL_API = true
```
Forces the use of the real API, even if the environment is different from “_production_”.

## Usage

```php

use BplanComponents\WebIoConnect\Connectors\WebIoConnector;
use BplanComponents\WebIoConnect\Enums\State;
use BplanComponents\WebIoConnect\Enums\DeviceType;

$Connector = new WebIoConnector(DeviceType::WebIo57838, 'http://example.com:8080');

$Connector->sendOutputState(2, State::On);

```
The relay types \#57732, \#57832 and \#57838 are currently supported.

To prevent a production relay from being accidentally controlled during development or from a test system, _Web-IO Connect_ comes with its own API that simulates the functionality of the real API.  If Laravel is used in an environment other than “_production_”, all requests are redirected to the API routes in the project itself - regardless of which URL is passed to the constructor as the base route.
To force the use of the real API, the configuration setting `WEB_IO_CONNECT_FORCE_REAL_API = true` can be used.

The API routes can be displayed with the following command:

```bash
php artisan route:list --path=api/web-io-faker
```

## Dependencies
* "php": "\*"
