<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connect
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2024, 2025 bplan-solutions GmbH & Co. KG <http://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\WebIoConnect\Enums;


/**
 * Enum Class
 *
 * @version     1.0.0 / 2025-04-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum DeviceType: string {


/* +++ CASES +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    case WebIo57730 = '57730';

    case WebIo57731 = '57731';

    case WebIo57732 = '57732';

    case WebIo57733 = '57733';

    case WebIo57736 = '57736';

    case WebIo57737 = '57737';

    case WebIo57738 = '57738';

    case WebIo57832 = '57832';

    case WebIo57838 = '57838';


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return      string
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getClass(): string
    {
        return match ($this) {
            // self::WebIo57731 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57731::class,
            self::WebIo57732 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57732::class,
            // self::WebIo57733 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57733::class,
            // self::WebIo57736 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57736::class,
            // self::WebIo57737 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57737::class,
            // self::WebIo57738 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57738::class,
            self::WebIo57832 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57832::class,
            self::WebIo57838 => \BplanComponents\WebIoConnect\Devices\WebIo\WebIo57838::class,

            default => throw new \LogicException('Class mapping missing for DeviceType ['.$this->value.']')
        };
    } // getClass()


/* +++ STATIC METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert den Case zum übergebenen Schlüssel
     *
     * @param       string $name
     *
     * @return      DeviceType|null
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByName(string $name): DeviceType|null
    {
        if (defined('self::'.$name) === false) {
            return null;
        }
        return constant('self::'.$name);

    } // getByName()


    /**
     * Liefert den Case zum übergebenen Wert
     *
     * @param       int $value
     *
     * @return      DeviceType|null
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByValue(int $value): DeviceType|null
    {
        if (DeviceType::tryFrom($value) === null) {
            return null;
        }
        return DeviceType::from($value);

    } // getByValue()


} // enum DeviceType: string {}