<?php
/**
 * Enum Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connect
 * @subpackage  Enums
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 bplan-solutions GmbH & Co. KG <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\WebIoConnect\Enums;


/**
 * Enum Class
 *
 * @version     1.0.0 / 2025-04-26
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
enum State: string {


/* +++ CASES +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


    case Off = 'OFF';

    case On  = 'ON';


/* +++ STATIC METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     * Liefert den Case zum übergebenen Schlüssel
     *
     * @param       string $name
     *
     * @return      State|null
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByName(string $name): State|null
    {
        if (defined('self::'.$name) === false) {
            return null;
        }
        return constant('self::'.$name);

    } // getByName()


    /**
     * Liefert den Case zum übergebenen Wert
     *
     * @param       int $value
     *
     * @return      State|null
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public static function getByValue(int $value): State|null
    {
        if (State::tryFrom($value) === null) {
            return null;
        }
        return State::from($value);

    } // getByValue()


} // enum State {}
