<?php
/**
 * IO Class
 *
 * @version     1.0.$Revision:$
 * @version     SVN: $Id:$
 * @package     bplan-components/web-io-connect
 * @subpackage  Io
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 * @copyright   Copyright (C) 2025 Wassilios Meletiadis <https://www.bplan-solutions.de/>
 * /Δ\
 */

namespace BplanComponents\WebIoConnect\Api;


use BplanComponents\WebIoConnect\Devices\BaseIo;


/**
 * Device Class
 *
 * @version     1.0.1 / 2025-04-27
 * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
 */
class Credentials
{


/* +++ TRAITS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ CLASS CONSTANTS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT MEMBERS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *          string $_password
     */
    private null|string $_password = null;


    /**
     *          string $_userName
     */
    private string $_userName;


/* +++ CLASS MEMBERS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


/* +++ OBJECT METHODS +++ +++++++++++++++++++++++++++++++++++++++++++++++++++ */


    /**
     *
     * @return 	    void
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function __construct()
    {
        $config = config('web-io-connect.auth');

        if ($config['password'] !== null) {
            $this->_password = trim($config['password']);

            if (strtolower($config['usertype']) === 'admin') {
                $this->_userName = 'admin';
            } else {
                $this->_userName = 'operator';
            }
        }
    } // __construct()


    /**
     *
     * @return 	    string|null
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getPassword(): string|null
    {
        return $this->_password;

    } // getPassword()


    /**
     *
     * @return 	    string
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function getUserName(): string
    {
        return $this->_userName;

    } // getUserName()


    /**
     *
     * @return 	    bool
     *
     * @version     1.0.0 / 2025-04-26
     * @author      Wassilios Meletiadis <wassilios.meletiadis@bplan-solutions.de>
     */
    public function hasCredentials(): bool
    {
        return $this->_password !== null;

    } // hasCredentials()


/* +++ CLASS METHODS +++ ++++++++++++++++++++++++++++++++++++++++++++++++++++ */


} // class Credentials {}
